package com.taobao.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.AlibabaLatourWinrecordQueryResponse;

/**
 * TOP API: alibaba.latour.winrecord.query request
 * 
 * @author top auto create
 * @since 1.0, 2022.04.28
 */
public class AlibabaLatourWinrecordQueryRequest extends BaseTaobaoRequest<AlibabaLatourWinrecordQueryResponse> {
	
	

	/** 
	* 当前分页数
	 */
	private Long currentPage;

	/** 
	* 每页记录数
	 */
	private Long pageSize;

	/** 
	* 投放计划code
	 */
	private String strategyCodes;

	/** 
	* 转换用户类型
	 */
	private String transformedUserType;

	/** 
	* 用户id
	 */
	private String userId;

	/** 
	* 当前用户类型
	 */
	private String userType;

	public void setCurrentPage(Long currentPage) {
		this.currentPage = currentPage;
	}

	public Long getCurrentPage() {
		return this.currentPage;
	}

	public void setPageSize(Long pageSize) {
		this.pageSize = pageSize;
	}

	public Long getPageSize() {
		return this.pageSize;
	}

	public void setStrategyCodes(String strategyCodes) {
		this.strategyCodes = strategyCodes;
	}

	public String getStrategyCodes() {
		return this.strategyCodes;
	}

	public void setTransformedUserType(String transformedUserType) {
		this.transformedUserType = transformedUserType;
	}

	public String getTransformedUserType() {
		return this.transformedUserType;
	}

	public void setUserId(String userId) {
		this.userId = userId;
	}

	public String getUserId() {
		return this.userId;
	}

	public void setUserType(String userType) {
		this.userType = userType;
	}

	public String getUserType() {
		return this.userType;
	}

	public String getApiMethodName() {
		return "alibaba.latour.winrecord.query";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("current_page", this.currentPage);
		txtParams.put("page_size", this.pageSize);
		txtParams.put("strategy_codes", this.strategyCodes);
		txtParams.put("transformed_user_type", this.transformedUserType);
		txtParams.put("user_id", this.userId);
		txtParams.put("user_type", this.userType);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<AlibabaLatourWinrecordQueryResponse> getResponseClass() {
		return AlibabaLatourWinrecordQueryResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(strategyCodes, "strategyCodes");
		RequestCheckUtils.checkMaxListSize(strategyCodes, 20, "strategyCodes");
		RequestCheckUtils.checkNotEmpty(userId, "userId");
		RequestCheckUtils.checkNotEmpty(userType, "userType");
	}
	

}