package com.taobao.api.request;

import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.util.json.JSONValidatingReader;
import com.taobao.api.TaobaoObject;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.json.JSONWriter;
import com.taobao.api.response.AlibabaTmjoyCcEventSendResponse;

/**
 * TOP API: alibaba.tmjoy.cc.event.send request
 * 
 * @author top auto create
 * @since 1.0, 2022.09.01
 */
public class AlibabaTmjoyCcEventSendRequest extends BaseTaobaoRequest<AlibabaTmjoyCcEventSendResponse> {
	
	

	/** 
	* 事件请求体
	 */
	private String eventRequest;

	public void setEventRequest(String eventRequest) {
		this.eventRequest = eventRequest;
	}

	public void setEventRequest(EventRequest eventRequest) {
		this.eventRequest = new JSONWriter(false,true).write(eventRequest);
	}

	public String getEventRequest() {
		return this.eventRequest;
	}

	public String getApiMethodName() {
		return "alibaba.tmjoy.cc.event.send";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("event_request", this.eventRequest);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<AlibabaTmjoyCcEventSendResponse> getResponseClass() {
		return AlibabaTmjoyCcEventSendResponse.class;
	}

	public void check() throws ApiRuleException {
	}
	
	/**
 * 事件请求体
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class EventRequest extends TaobaoObject {

	private static final long serialVersionUID = 7365357847144762911L;

	/**
		 * 内容模板ID
		 */
		@ApiField("content_id")
		private Long contentId;
		/**
		 * 需要执行用户加密后的目标用户
		 */
		@ApiField("encrypt_invoke_user_id")
		private String encryptInvokeUserId;
		/**
		 * 加密后的目标用户
		 */
		@ApiField("encrypt_target_user_id")
		private String encryptTargetUserId;
		/**
		 * 事件类型
		 */
		@ApiField("event_type")
		private String eventType;
		/**
		 * 用户类型默认uic
		 */
		@ApiField("invoke_user_type")
		private String invokeUserType;
		/**
		 * 消息内容
		 */
		@ApiField("msg_data")
		private String msgData;
		/**
		 * 消息类型
		 */
		@ApiField("msg_type")
		private Long msgType;
		/**
		 * 请求附加参数
		 */
		@ApiField("request_param")
		private String requestParam;
		/**
		 * 房间ID
		 */
		@ApiField("room_id")
		private String roomId;
		/**
		 * 场景ID
		 */
		@ApiField("scene_id")
		private Long sceneId;
		/**
		 * 发送者openid
		 */
		@ApiField("sender_open_id")
		private String senderOpenId;
	

	public Long getContentId() {
			return this.contentId;
		}
		public void setContentId(Long contentId) {
			this.contentId = contentId;
		}
		public String getEncryptInvokeUserId() {
			return this.encryptInvokeUserId;
		}
		public void setEncryptInvokeUserId(String encryptInvokeUserId) {
			this.encryptInvokeUserId = encryptInvokeUserId;
		}
		public String getEncryptTargetUserId() {
			return this.encryptTargetUserId;
		}
		public void setEncryptTargetUserId(String encryptTargetUserId) {
			this.encryptTargetUserId = encryptTargetUserId;
		}
		public String getEventType() {
			return this.eventType;
		}
		public void setEventType(String eventType) {
			this.eventType = eventType;
		}
		public String getInvokeUserType() {
			return this.invokeUserType;
		}
		public void setInvokeUserType(String invokeUserType) {
			this.invokeUserType = invokeUserType;
		}
		public String getMsgData() {
			return this.msgData;
		}
		public void setMsgData(String msgData) {
			this.msgData = msgData;
		}
		public Long getMsgType() {
			return this.msgType;
		}
		public void setMsgType(Long msgType) {
			this.msgType = msgType;
		}
		public String getRequestParam() {
			return this.requestParam;
		}
		public void setRequestParam(String requestParam) {
			this.requestParam = requestParam;
		}
		public void setRequestParamString(String requestParam) {
			this.requestParam = requestParam;
		}
		
		public String getRoomId() {
			return this.roomId;
		}
		public void setRoomId(String roomId) {
			this.roomId = roomId;
		}
		public Long getSceneId() {
			return this.sceneId;
		}
		public void setSceneId(Long sceneId) {
			this.sceneId = sceneId;
		}
		public String getSenderOpenId() {
			return this.senderOpenId;
		}
		public void setSenderOpenId(String senderOpenId) {
			this.senderOpenId = senderOpenId;
		}

}


}