package com.taobao.api.request;

import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.AliexpressSocialPromoCouponAssignResponse;

/**
 * TOP API: aliexpress.social.promo.coupon.assign request
 * 
 * @author top auto create
 * @since 1.0, 2022.04.28
 */
public class AliexpressSocialPromoCouponAssignRequest extends BaseTaobaoRequest<AliexpressSocialPromoCouponAssignResponse> {
	
	

	/** 
	* coupon code
	 */
	private String couponCode;

	/** 
	* vk id
	 */
	private Long vkId;

	public void setCouponCode(String couponCode) {
		this.couponCode = couponCode;
	}

	public String getCouponCode() {
		return this.couponCode;
	}

	public void setVkId(Long vkId) {
		this.vkId = vkId;
	}

	public Long getVkId() {
		return this.vkId;
	}

	public String getApiMethodName() {
		return "aliexpress.social.promo.coupon.assign";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("coupon_code", this.couponCode);
		txtParams.put("vk_id", this.vkId);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<AliexpressSocialPromoCouponAssignResponse> getResponseClass() {
		return AliexpressSocialPromoCouponAssignResponse.class;
	}

	public void check() throws ApiRuleException {
	}
	

}