package com.taobao.api.request;

import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.CardExpandcardQueryResponse;

/**
 * TOP API: taobao.card.expandcard.query request
 * 
 * @author top auto create
 * @since 1.0, 2022.04.28
 */
public class CardExpandcardQueryRequest extends BaseTaobaoRequest<CardExpandcardQueryResponse> {
	
	

	/** 
	* 支付宝accountNo
	 */
	private String accountNo;

	/** 
	* 卡使用范围，不传则会查询所有
	 */
	private String usedScopeCode;

	public void setAccountNo(String accountNo) {
		this.accountNo = accountNo;
	}

	public String getAccountNo() {
		return this.accountNo;
	}

	public void setUsedScopeCode(String usedScopeCode) {
		this.usedScopeCode = usedScopeCode;
	}

	public String getUsedScopeCode() {
		return this.usedScopeCode;
	}

	public String getApiMethodName() {
		return "taobao.card.expandcard.query";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("account_no", this.accountNo);
		txtParams.put("used_scope_code", this.usedScopeCode);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<CardExpandcardQueryResponse> getResponseClass() {
		return CardExpandcardQueryResponse.class;
	}

	public void check() throws ApiRuleException {
	}
	

}