package com.taobao.api.request;

import com.taobao.api.domain.SingleBenefitRequest;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.json.JSONWriter;
import com.taobao.api.response.MobilePromotionBenefitActivitySendResponse;

/**
 * TOP API: taobao.mobile.promotion.benefit.activity.send request
 * 
 * @author top auto create
 * @since 1.0, 2018.11.10
 */
public class MobilePromotionBenefitActivitySendRequest extends BaseTaobaoRequest<MobilePromotionBenefitActivitySendResponse> {
	
	

	/** 
	* 单用户权益发放请求
	 */
	private String singleBenefitRequest;

	public void setSingleBenefitRequest(String singleBenefitRequest) {
		this.singleBenefitRequest = singleBenefitRequest;
	}

	public void setSingleBenefitRequest(SingleBenefitRequest singleBenefitRequest) {
		this.singleBenefitRequest = new JSONWriter(false,true).write(singleBenefitRequest);
	}

	public String getSingleBenefitRequest() {
		return this.singleBenefitRequest;
	}

	public String getApiMethodName() {
		return "taobao.mobile.promotion.benefit.activity.send";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("single_benefit_request", this.singleBenefitRequest);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<MobilePromotionBenefitActivitySendResponse> getResponseClass() {
		return MobilePromotionBenefitActivitySendResponse.class;
	}

	public void check() throws ApiRuleException {
	}
	

}