package com.taobao.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.MobilePromotionBenefitActivitySendShareResponse;

/**
 * TOP API: taobao.mobile.promotion.benefit.activity.send.share request
 * 
 * @author top auto create
 * @since 1.0, 2018.07.25
 */
public class MobilePromotionBenefitActivitySendShareRequest extends BaseTaobaoRequest<MobilePromotionBenefitActivitySendShareResponse> {
	
	

	/** 
	* 权益类型    其中ALIPAY_COUPON 对应的type值是1
	 */
	private Long benefitType;

	/** 
	* 权益关联的活动ID
	 */
	private String bizId;

	/** 
	* 活动详情id
	 */
	private Long detailId;

	/** 
	* 广播ID
	 */
	private Long feedId;

	/** 
	* 关联活动id
	 */
	private Long relationId;

	/** 
	* 权益发放数量
	 */
	private Long sendCount;

	/** 
	* 和bizId一起使用，标记分享链路的key。
	 */
	private String shareKey;

	/** 
	* 分享链路上的用户及用户是否发奖，u1_true,u2_true
	 */
	private String shareUsers;

	/** 
	* 调试线索
	 */
	private String traceId;

	/** 
	* 事务id
	 */
	private String uniqueId;

	public void setBenefitType(Long benefitType) {
		this.benefitType = benefitType;
	}

	public Long getBenefitType() {
		return this.benefitType;
	}

	public void setBizId(String bizId) {
		this.bizId = bizId;
	}

	public String getBizId() {
		return this.bizId;
	}

	public void setDetailId(Long detailId) {
		this.detailId = detailId;
	}

	public Long getDetailId() {
		return this.detailId;
	}

	public void setFeedId(Long feedId) {
		this.feedId = feedId;
	}

	public Long getFeedId() {
		return this.feedId;
	}

	public void setRelationId(Long relationId) {
		this.relationId = relationId;
	}

	public Long getRelationId() {
		return this.relationId;
	}

	public void setSendCount(Long sendCount) {
		this.sendCount = sendCount;
	}

	public Long getSendCount() {
		return this.sendCount;
	}

	public void setShareKey(String shareKey) {
		this.shareKey = shareKey;
	}

	public String getShareKey() {
		return this.shareKey;
	}

	public void setShareUsers(String shareUsers) {
		this.shareUsers = shareUsers;
	}

	public String getShareUsers() {
		return this.shareUsers;
	}

	public void setTraceId(String traceId) {
		this.traceId = traceId;
	}

	public String getTraceId() {
		return this.traceId;
	}

	public void setUniqueId(String uniqueId) {
		this.uniqueId = uniqueId;
	}

	public String getUniqueId() {
		return this.uniqueId;
	}

	public String getApiMethodName() {
		return "taobao.mobile.promotion.benefit.activity.send.share";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("benefit_type", this.benefitType);
		txtParams.put("biz_id", this.bizId);
		txtParams.put("detail_id", this.detailId);
		txtParams.put("feed_id", this.feedId);
		txtParams.put("relation_id", this.relationId);
		txtParams.put("send_count", this.sendCount);
		txtParams.put("share_key", this.shareKey);
		txtParams.put("share_users", this.shareUsers);
		txtParams.put("trace_id", this.traceId);
		txtParams.put("unique_id", this.uniqueId);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<MobilePromotionBenefitActivitySendShareResponse> getResponseClass() {
		return MobilePromotionBenefitActivitySendShareResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(benefitType, "benefitType");
		RequestCheckUtils.checkNotEmpty(bizId, "bizId");
		RequestCheckUtils.checkNotEmpty(detailId, "detailId");
		RequestCheckUtils.checkNotEmpty(feedId, "feedId");
		RequestCheckUtils.checkNotEmpty(relationId, "relationId");
		RequestCheckUtils.checkNotEmpty(sendCount, "sendCount");
		RequestCheckUtils.checkNotEmpty(traceId, "traceId");
		RequestCheckUtils.checkNotEmpty(uniqueId, "uniqueId");
	}
	

}