package com.taobao.api.request;

import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.TaobaoObject;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.json.JSONWriter;
import com.taobao.api.response.PromotionBenefitActivityDetailGetResponse;

/**
 * TOP API: taobao.promotion.benefit.activity.detail.get request
 * 
 * @author top auto create
 * @since 1.0, 2022.04.28
 */
public class PromotionBenefitActivityDetailGetRequest extends BaseTaobaoRequest<PromotionBenefitActivityDetailGetResponse> {
	
	

	/** 
	* 查询活动关联权益详情的请求
	 */
	private String queryRequest;

	public void setQueryRequest(String queryRequest) {
		this.queryRequest = queryRequest;
	}

	public void setQueryRequest(ActivityRelationDetailRequest queryRequest) {
		this.queryRequest = new JSONWriter(false,true).write(queryRequest);
	}

	public String getQueryRequest() {
		return this.queryRequest;
	}

	public String getApiMethodName() {
		return "taobao.promotion.benefit.activity.detail.get";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("query_request", this.queryRequest);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<PromotionBenefitActivityDetailGetResponse> getResponseClass() {
		return PromotionBenefitActivityDetailGetResponse.class;
	}

	public void check() throws ApiRuleException {
	}
	
	/**
 * 查询活动关联权益详情的请求
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class ActivityRelationDetailRequest extends TaobaoObject {

	private static final long serialVersionUID = 6491553112129272258L;

	/**
		 * ISV活动关联权益后获得的关联ID
		 */
		@ApiField("relation_id")
		private Long relationId;
		/**
		 * 活动状态(VALID  ， DELETE)
		 */
		@ApiField("status")
		private String status;
	

	public Long getRelationId() {
			return this.relationId;
		}
		public void setRelationId(Long relationId) {
			this.relationId = relationId;
		}
		public String getStatus() {
			return this.status;
		}
		public void setStatus(String status) {
			this.status = status;
		}

}


}