package com.taobao.api.request;

import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.mapping.ApiListField;
import com.taobao.api.TaobaoObject;
import java.util.Date;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.json.JSONWriter;
import com.taobao.api.response.PromotionBenefitActivityRelationResponse;

/**
 * TOP API: taobao.promotion.benefit.activity.relation request
 * 
 * @author top auto create
 * @since 1.0, 2022.04.28
 */
public class PromotionBenefitActivityRelationRequest extends BaseTaobaoRequest<PromotionBenefitActivityRelationResponse> {
	
	

	/** 
	* 活动关联权益请求参数
	 */
	private String relationRequest;

	public void setRelationRequest(String relationRequest) {
		this.relationRequest = relationRequest;
	}

	public void setRelationRequest(RelationActivityBenefitRequest relationRequest) {
		this.relationRequest = new JSONWriter(false,true).write(relationRequest);
	}

	public String getRelationRequest() {
		return this.relationRequest;
	}

	public String getApiMethodName() {
		return "taobao.promotion.benefit.activity.relation";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("relation_request", this.relationRequest);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<PromotionBenefitActivityRelationResponse> getResponseClass() {
		return PromotionBenefitActivityRelationResponse.class;
	}

	public void check() throws ApiRuleException {
	}
	
	/**
 * 活动关联的权益信息，可以从权益选择器API中获取
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class ActivityBenefitDetailVo extends TaobaoObject {

	private static final long serialVersionUID = 6889924518936364475L;

	/**
		 * 权益ID
		 */
		@ApiField("benefit_id")
		private Long benefitId;
		/**
		 * 权益类型
		 */
		@ApiField("benefit_type")
		private String benefitType;
		/**
		 * 权益标识
		 */
		@ApiField("config_id")
		private Long configId;
	

	public Long getBenefitId() {
			return this.benefitId;
		}
		public void setBenefitId(Long benefitId) {
			this.benefitId = benefitId;
		}
		public String getBenefitType() {
			return this.benefitType;
		}
		public void setBenefitType(String benefitType) {
			this.benefitType = benefitType;
		}
		public Long getConfigId() {
			return this.configId;
		}
		public void setConfigId(Long configId) {
			this.configId = configId;
		}

}

	/**
 * 同步权益活动的概述信息，用于卖家后台查看
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class BenefitActivityVo extends TaobaoObject {

	private static final long serialVersionUID = 2245966662829329341L;

	/**
		 * ISV活动的具体地址
		 */
		@ApiField("activity_url")
		private String activityUrl;
		/**
		 * 活动描述
		 */
		@ApiField("desc")
		private String desc;
		/**
		 * 活动结束时间
		 */
		@ApiField("end_time")
		private Date endTime;
		/**
		 * 活动名称
		 */
		@ApiField("name")
		private String name;
		/**
		 * 活动的开始时间
		 */
		@ApiField("start_time")
		private Date startTime;
		/**
		 * 活动类型
		 */
		@ApiField("type")
		private String type;
	

	public String getActivityUrl() {
			return this.activityUrl;
		}
		public void setActivityUrl(String activityUrl) {
			this.activityUrl = activityUrl;
		}
		public String getDesc() {
			return this.desc;
		}
		public void setDesc(String desc) {
			this.desc = desc;
		}
		public Date getEndTime() {
			return this.endTime;
		}
		public void setEndTime(Date endTime) {
			this.endTime = endTime;
		}
		public String getName() {
			return this.name;
		}
		public void setName(String name) {
			this.name = name;
		}
		public Date getStartTime() {
			return this.startTime;
		}
		public void setStartTime(Date startTime) {
			this.startTime = startTime;
		}
		public String getType() {
			return this.type;
		}
		public void setType(String type) {
			this.type = type;
		}

}

	/**
 * 活动关联权益请求参数
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class RelationActivityBenefitRequest extends TaobaoObject {

	private static final long serialVersionUID = 3396833771722461786L;

	/**
		 * 活动关联的权益信息，可以从权益选择器API中获取
		 */
		@ApiListField("add_detail_vos")
		@ApiField("activity_benefit_detail_vo")
		private List<ActivityBenefitDetailVo> addDetailVos;
		/**
		 * 同步权益活动的概述信息，用于卖家后台查看
		 */
		@ApiField("benefit_activity_vo")
		private BenefitActivityVo benefitActivityVo;
	

	public List<ActivityBenefitDetailVo> getAddDetailVos() {
			return this.addDetailVos;
		}
		public void setAddDetailVos(List<ActivityBenefitDetailVo> addDetailVos) {
			this.addDetailVos = addDetailVos;
		}
		public BenefitActivityVo getBenefitActivityVo() {
			return this.benefitActivityVo;
		}
		public void setBenefitActivityVo(BenefitActivityVo benefitActivityVo) {
			this.benefitActivityVo = benefitActivityVo;
		}

}


}