package com.taobao.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Date;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.PromotionBenefitActivityTimeUpdateResponse;

/**
 * TOP API: taobao.promotion.benefit.activity.time.update request
 * 
 * @author top auto create
 * @since 1.0, 2022.09.20
 */
public class PromotionBenefitActivityTimeUpdateRequest extends BaseTaobaoRequest<PromotionBenefitActivityTimeUpdateResponse> {
	
	

	/** 
	* 活动的i结束时间
	 */
	private Date endTime;

	/** 
	* ISV活动关联权益后获得的关联ID
	 */
	private Long relationId;

	/** 
	* 活动的开始时间
	 */
	private Date startTime;

	public void setEndTime(Date endTime) {
		this.endTime = endTime;
	}

	public Date getEndTime() {
		return this.endTime;
	}

	public void setRelationId(Long relationId) {
		this.relationId = relationId;
	}

	public Long getRelationId() {
		return this.relationId;
	}

	public void setStartTime(Date startTime) {
		this.startTime = startTime;
	}

	public Date getStartTime() {
		return this.startTime;
	}

	public String getApiMethodName() {
		return "taobao.promotion.benefit.activity.time.update";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("end_time", this.endTime);
		txtParams.put("relation_id", this.relationId);
		txtParams.put("start_time", this.startTime);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<PromotionBenefitActivityTimeUpdateResponse> getResponseClass() {
		return PromotionBenefitActivityTimeUpdateResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(endTime, "endTime");
		RequestCheckUtils.checkNotEmpty(relationId, "relationId");
		RequestCheckUtils.checkNotEmpty(startTime, "startTime");
	}
	

}