package com.taobao.api.request;

import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.mapping.ApiListField;
import com.taobao.api.TaobaoObject;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.json.JSONWriter;
import com.taobao.api.response.PromotionBenefitActivityUpdateResponse;

/**
 * TOP API: taobao.promotion.benefit.activity.update request
 * 
 * @author top auto create
 * @since 1.0, 2022.09.20
 */
public class PromotionBenefitActivityUpdateRequest extends BaseTaobaoRequest<PromotionBenefitActivityUpdateResponse> {
	
	

	/** 
	* 修改关联的权益的活动请求
	 */
	private String updateRequest;

	public void setUpdateRequest(String updateRequest) {
		this.updateRequest = updateRequest;
	}

	public void setUpdateRequest(UpdateBenefitActivityRequest updateRequest) {
		this.updateRequest = new JSONWriter(false,true).write(updateRequest);
	}

	public String getUpdateRequest() {
		return this.updateRequest;
	}

	public String getApiMethodName() {
		return "taobao.promotion.benefit.activity.update";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("update_request", this.updateRequest);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<PromotionBenefitActivityUpdateResponse> getResponseClass() {
		return PromotionBenefitActivityUpdateResponse.class;
	}

	public void check() throws ApiRuleException {
	}
	
	/**
 * 活动关联的权益信息，可以从权益选择器API中获取
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class ActivityBenefitDetailVo extends TaobaoObject {

	private static final long serialVersionUID = 4266556123416163119L;

	/**
		 * 权益ID
		 */
		@ApiField("benefit_id")
		private Long benefitId;
		/**
		 * 权益类型
		 */
		@ApiField("benefit_type")
		private String benefitType;
	

	public Long getBenefitId() {
			return this.benefitId;
		}
		public void setBenefitId(Long benefitId) {
			this.benefitId = benefitId;
		}
		public String getBenefitType() {
			return this.benefitType;
		}
		public void setBenefitType(String benefitType) {
			this.benefitType = benefitType;
		}

}

	/**
 * 同步权益活动的概述信息，方便卖家后台查看
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class UpdateBenefitActivityVo extends TaobaoObject {

	private static final long serialVersionUID = 4474686162154173761L;

	/**
		 * ISV活动的活动地址
		 */
		@ApiField("activity_url")
		private String activityUrl;
		/**
		 * 活动描述
		 */
		@ApiField("desc")
		private String desc;
		/**
		 * 活动名称
		 */
		@ApiField("name")
		private String name;
		/**
		 * ISV活动关联权益后获得的关联ID
		 */
		@ApiField("relation_id")
		private Long relationId;
	

	public String getActivityUrl() {
			return this.activityUrl;
		}
		public void setActivityUrl(String activityUrl) {
			this.activityUrl = activityUrl;
		}
		public String getDesc() {
			return this.desc;
		}
		public void setDesc(String desc) {
			this.desc = desc;
		}
		public String getName() {
			return this.name;
		}
		public void setName(String name) {
			this.name = name;
		}
		public Long getRelationId() {
			return this.relationId;
		}
		public void setRelationId(Long relationId) {
			this.relationId = relationId;
		}

}

	/**
 * 需要删除的已经关联的权益
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class DeleteActivityBenefitDetailVo extends TaobaoObject {

	private static final long serialVersionUID = 4841744437985425863L;

	/**
		 * 活动关联权益后生产的详情ID
		 */
		@ApiField("id")
		private Long id;
	

	public Long getId() {
			return this.id;
		}
		public void setId(Long id) {
			this.id = id;
		}

}

	/**
 * 修改关联的权益的活动请求
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class UpdateBenefitActivityRequest extends TaobaoObject {

	private static final long serialVersionUID = 5542282912358263773L;

	/**
		 * 活动关联的权益信息，可以从权益选择器API中获取
		 */
		@ApiListField("add_detail_vos")
		@ApiField("activity_benefit_detail_vo")
		private List<ActivityBenefitDetailVo> addDetailVos;
		/**
		 * 同步权益活动的概述信息，方便卖家后台查看
		 */
		@ApiField("benefit_activity_vo")
		private UpdateBenefitActivityVo benefitActivityVo;
		/**
		 * 需要删除的已经关联的权益
		 */
		@ApiListField("delete_detail_vos")
		@ApiField("delete_activity_benefit_detail_vo")
		private List<DeleteActivityBenefitDetailVo> deleteDetailVos;
	

	public List<ActivityBenefitDetailVo> getAddDetailVos() {
			return this.addDetailVos;
		}
		public void setAddDetailVos(List<ActivityBenefitDetailVo> addDetailVos) {
			this.addDetailVos = addDetailVos;
		}
		public UpdateBenefitActivityVo getBenefitActivityVo() {
			return this.benefitActivityVo;
		}
		public void setBenefitActivityVo(UpdateBenefitActivityVo benefitActivityVo) {
			this.benefitActivityVo = benefitActivityVo;
		}
		public List<DeleteActivityBenefitDetailVo> getDeleteDetailVos() {
			return this.deleteDetailVos;
		}
		public void setDeleteDetailVos(List<DeleteActivityBenefitDetailVo> deleteDetailVos) {
			this.deleteDetailVos = deleteDetailVos;
		}

}


}