package com.taobao.api.request;

import com.taobao.api.domain.BenefitCallbackRequest;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.json.JSONWriter;
import com.taobao.api.response.PromotionBenefitSendCallbackResponse;

/**
 * TOP API: taobao.promotion.benefit.send.callback request
 * 
 * @author top auto create
 * @since 1.0, 2015.07.30
 */
public class PromotionBenefitSendCallbackRequest extends BaseTaobaoRequest<PromotionBenefitSendCallbackResponse> {
	
	

	/** 
	* 权益中心发放回调消息
	 */
	private String callbackRequest;

	public void setCallbackRequest(String callbackRequest) {
		this.callbackRequest = callbackRequest;
	}

	public void setCallbackRequest(BenefitCallbackRequest callbackRequest) {
		this.callbackRequest = new JSONWriter(false,true).write(callbackRequest);
	}

	public String getCallbackRequest() {
		return this.callbackRequest;
	}

	public String getApiMethodName() {
		return "taobao.promotion.benefit.send.callback";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("callback_request", this.callbackRequest);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<PromotionBenefitSendCallbackResponse> getResponseClass() {
		return PromotionBenefitSendCallbackResponse.class;
	}

	public void check() throws ApiRuleException {
	}
	

}