package com.taobao.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Date;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.PromotionCouponAddResponse;

/**
 * TOP API: taobao.promotion.coupon.add request
 * 
 * @author top auto create
 * @since 1.0, 2022.04.28
 */
public class PromotionCouponAddRequest extends BaseTaobaoRequest<PromotionCouponAddResponse> {
	
	

	/** 
	* 订单满多少元才能用这个优惠券，500就是满500元才能使用
	 */
	private Long condition;

	/** 
	* 优惠券的面额，必须是3，5，10，20，50，100
	 */
	private Long denominations;

	/** 
	* 优惠券的截止日期
	 */
	private Date endTime;

	/** 
	* 优惠券的生效时间
	 */
	private Date startTime;

	public void setCondition(Long condition) {
		this.condition = condition;
	}

	public Long getCondition() {
		return this.condition;
	}

	public void setDenominations(Long denominations) {
		this.denominations = denominations;
	}

	public Long getDenominations() {
		return this.denominations;
	}

	public void setEndTime(Date endTime) {
		this.endTime = endTime;
	}

	public Date getEndTime() {
		return this.endTime;
	}

	public void setStartTime(Date startTime) {
		this.startTime = startTime;
	}

	public Date getStartTime() {
		return this.startTime;
	}

	public String getApiMethodName() {
		return "taobao.promotion.coupon.add";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("condition", this.condition);
		txtParams.put("denominations", this.denominations);
		txtParams.put("end_time", this.endTime);
		txtParams.put("start_time", this.startTime);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<PromotionCouponAddResponse> getResponseClass() {
		return PromotionCouponAddResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(denominations, "denominations");
		RequestCheckUtils.checkNotEmpty(endTime, "endTime");
	}
	

}