package com.taobao.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.PromotionCouponApplyResponse;

/**
 * TOP API: taobao.promotion.coupon.apply request
 * 
 * @author top auto create
 * @since 1.0, 2022.09.20
 */
public class PromotionCouponApplyRequest extends BaseTaobaoRequest<PromotionCouponApplyResponse> {
	
	

	/** 
	* 卖家id
	 */
	private String sellerId;

	/** 
	* 传播id
	 */
	private String spreadId;

	public void setSellerId(String sellerId) {
		this.sellerId = sellerId;
	}

	public String getSellerId() {
		return this.sellerId;
	}

	public void setSpreadId(String spreadId) {
		this.spreadId = spreadId;
	}

	public String getSpreadId() {
		return this.spreadId;
	}

	public String getApiMethodName() {
		return "taobao.promotion.coupon.apply";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("seller_id", this.sellerId);
		txtParams.put("spread_id", this.spreadId);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<PromotionCouponApplyResponse> getResponseClass() {
		return PromotionCouponApplyResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(sellerId, "sellerId");
		RequestCheckUtils.checkNotEmpty(spreadId, "spreadId");
	}
	

}