package com.taobao.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.PromotionCouponSellerGetResponse;

/**
 * TOP API: taobao.promotion.coupon.seller.get request
 * 
 * @author top auto create
 * @since 1.0, 2018.07.11
 */
public class PromotionCouponSellerGetRequest extends BaseTaobaoRequest<PromotionCouponSellerGetResponse> {
	
	

	/** 
	* 商家id
	 */
	private Long sellerId;

	/** 
	* 券模板uuid
	 */
	private String uuid;

	public void setSellerId(Long sellerId) {
		this.sellerId = sellerId;
	}

	public Long getSellerId() {
		return this.sellerId;
	}

	public void setUuid(String uuid) {
		this.uuid = uuid;
	}

	public String getUuid() {
		return this.uuid;
	}

	public String getApiMethodName() {
		return "taobao.promotion.coupon.seller.get";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("seller_id", this.sellerId);
		txtParams.put("uuid", this.uuid);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<PromotionCouponSellerGetResponse> getResponseClass() {
		return PromotionCouponSellerGetResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkMinValue(sellerId, 0L, "sellerId");
	}
	

}