package com.taobao.api.request;

import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.util.RequestCheckUtils;
import com.taobao.api.TaobaoObject;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.json.JSONWriter;
import com.taobao.api.response.PromotionCouponSendResponse;

/**
 * TOP API: taobao.promotion.coupon.send request
 * 
 * @author top auto create
 * @since 1.0, 2022.06.07
 */
public class PromotionCouponSendRequest extends BaseTaobaoRequest<PromotionCouponSendResponse> {
	
	

	/** 
	* openuid
	 */
	private String buyerIds;

	/** 
	* 买家昵称用半角','号分割
	 */
	private String buyerNick;

	/** 
	* 优惠券的id
	 */
	private Long couponId;

	/** 
	* ouid
	 */
	private String ouidData;

	public void setBuyerIds(String buyerIds) {
		this.buyerIds = buyerIds;
	}

	public String getBuyerIds() {
		return this.buyerIds;
	}

	public void setBuyerNick(String buyerNick) {
		this.buyerNick = buyerNick;
	}

	public String getBuyerNick() {
		return this.buyerNick;
	}

	public void setCouponId(Long couponId) {
		this.couponId = couponId;
	}

	public Long getCouponId() {
		return this.couponId;
	}

	public void setOuidData(String ouidData) {
		this.ouidData = ouidData;
	}

	public void setOuidData(List<OuidData> ouidData) {
		this.ouidData = new JSONWriter(false,true).write(ouidData);
	}

	public String getOuidData() {
		return this.ouidData;
	}

	public String getApiMethodName() {
		return "taobao.promotion.coupon.send";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("buyer_ids", this.buyerIds);
		txtParams.put("buyer_nick", this.buyerNick);
		txtParams.put("coupon_id", this.couponId);
		txtParams.put("ouid_data", this.ouidData);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<PromotionCouponSendResponse> getResponseClass() {
		return PromotionCouponSendResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkMaxListSize(buyerIds, 999, "buyerIds");
		RequestCheckUtils.checkMaxListSize(buyerNick, 100, "buyerNick");
		RequestCheckUtils.checkNotEmpty(couponId, "couponId");
		RequestCheckUtils.checkObjectMaxListSize(ouidData, 999, "ouidData");
	}
	
	/**
 * ouid
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class OuidData extends TaobaoObject {

	private static final long serialVersionUID = 7125976716158649171L;

	/**
		 * ouid
		 */
		@ApiField("ouid")
		private String ouid;
	

	public String getOuid() {
			return this.ouid;
		}
		public void setOuid(String ouid) {
			this.ouid = ouid;
		}

}


}