package com.taobao.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.PromotionCouponSnsSendResponse;

/**
 * TOP API: taobao.promotion.coupon.sns.send request
 * 
 * @author top auto create
 * @since 1.0, 2022.04.08
 */
public class PromotionCouponSnsSendRequest extends BaseTaobaoRequest<PromotionCouponSnsSendResponse> {
	
	

	/** 
	* 买家昵称用半角','号分割
	 */
	private String buyerNick;

	/** 
	* 优惠券的id
	 */
	private Long couponId;

	/** 
	* asd
	 */
	private String openUids;

	public void setBuyerNick(String buyerNick) {
		this.buyerNick = buyerNick;
	}

	public String getBuyerNick() {
		return this.buyerNick;
	}

	public void setCouponId(Long couponId) {
		this.couponId = couponId;
	}

	public Long getCouponId() {
		return this.couponId;
	}

	public void setOpenUids(String openUids) {
		this.openUids = openUids;
	}

	public String getOpenUids() {
		return this.openUids;
	}

	public String getApiMethodName() {
		return "taobao.promotion.coupon.sns.send";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("buyer_nick", this.buyerNick);
		txtParams.put("coupon_id", this.couponId);
		txtParams.put("open_uids", this.openUids);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<PromotionCouponSnsSendResponse> getResponseClass() {
		return PromotionCouponSnsSendResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkMaxListSize(buyerNick, 100, "buyerNick");
		RequestCheckUtils.checkNotEmpty(couponId, "couponId");
		RequestCheckUtils.checkMaxListSize(openUids, 999, "openUids");
	}
	

}