package com.taobao.api.request;

import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.mapping.ApiListField;
import com.taobao.api.TaobaoObject;
import java.util.Date;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.json.JSONWriter;
import com.taobao.api.response.PromotioncenterCouponreadserviceCountcoupontemplatesbyResponse;

/**
 * TOP API: taobao.promotioncenter.couponreadservice.countcoupontemplatesby request
 * 
 * @author top auto create
 * @since 1.0, 2023.03.20
 */
public class PromotioncenterCouponreadserviceCountcoupontemplatesbyRequest extends BaseTaobaoRequest<PromotioncenterCouponreadserviceCountcoupontemplatesbyResponse> {
	
	

	/** 
	* 入参
	 */
	private String couponTemplateQuery;

	public void setCouponTemplateQuery(String couponTemplateQuery) {
		this.couponTemplateQuery = couponTemplateQuery;
	}

	public void setCouponTemplateQuery(CouponTemplateQuery couponTemplateQuery) {
		this.couponTemplateQuery = new JSONWriter(false,true).write(couponTemplateQuery);
	}

	public String getCouponTemplateQuery() {
		return this.couponTemplateQuery;
	}

	public String getApiMethodName() {
		return "taobao.promotioncenter.couponreadservice.countcoupontemplatesby";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("coupon_template_query", this.couponTemplateQuery);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<PromotioncenterCouponreadserviceCountcoupontemplatesbyResponse> getResponseClass() {
		return PromotioncenterCouponreadserviceCountcoupontemplatesbyResponse.class;
	}

	public void check() throws ApiRuleException {
	}
	
	/**
 * 入参
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class CouponTemplateQuery extends TaobaoObject {

	private static final long serialVersionUID = 7297915886488215465L;

	/**
		 * 卡券类型
		 */
		@ApiField("coupon_type")
		private Long couponType;
		/**
		 * 券类型list
		 */
		@ApiListField("coupon_type_array")
		@ApiField("number")
		private List<Long> couponTypeArray;
		/**
		 * 当前页码
		 */
		@ApiField("current_page")
		private Long currentPage;
		/**
		 * 日期范围
		 */
		@ApiField("date_condition")
		private Long dateCondition;
		/**
		 * 结束时间
		 */
		@ApiField("effective_end_time")
		private Date effectiveEndTime;
		/**
		 * 开始时间
		 */
		@ApiField("effective_start_time")
		private Date effectiveStartTime;
		/**
		 * 页面大小
		 */
		@ApiField("page_size")
		private Long pageSize;
		/**
		 * 是否可以分页
		 */
		@ApiField("query_page_vaild")
		private Boolean queryPageVaild;
		/**
		 * 状态
		 */
		@ApiField("status")
		private Long status;
		/**
		 * 卖家id
		 */
		@ApiField("supplier_id")
		private Long supplierId;
		/**
		 * 券标题
		 */
		@ApiField("title")
		private String title;
	

	public Long getCouponType() {
			return this.couponType;
		}
		public void setCouponType(Long couponType) {
			this.couponType = couponType;
		}
		public List<Long> getCouponTypeArray() {
			return this.couponTypeArray;
		}
		public void setCouponTypeArray(List<Long> couponTypeArray) {
			this.couponTypeArray = couponTypeArray;
		}
		public Long getCurrentPage() {
			return this.currentPage;
		}
		public void setCurrentPage(Long currentPage) {
			this.currentPage = currentPage;
		}
		public Long getDateCondition() {
			return this.dateCondition;
		}
		public void setDateCondition(Long dateCondition) {
			this.dateCondition = dateCondition;
		}
		public Date getEffectiveEndTime() {
			return this.effectiveEndTime;
		}
		public void setEffectiveEndTime(Date effectiveEndTime) {
			this.effectiveEndTime = effectiveEndTime;
		}
		public Date getEffectiveStartTime() {
			return this.effectiveStartTime;
		}
		public void setEffectiveStartTime(Date effectiveStartTime) {
			this.effectiveStartTime = effectiveStartTime;
		}
		public Long getPageSize() {
			return this.pageSize;
		}
		public void setPageSize(Long pageSize) {
			this.pageSize = pageSize;
		}
		public Boolean getQueryPageVaild() {
			return this.queryPageVaild;
		}
		public void setQueryPageVaild(Boolean queryPageVaild) {
			this.queryPageVaild = queryPageVaild;
		}
		public Long getStatus() {
			return this.status;
		}
		public void setStatus(Long status) {
			this.status = status;
		}
		public Long getSupplierId() {
			return this.supplierId;
		}
		public void setSupplierId(Long supplierId) {
			this.supplierId = supplierId;
		}
		public String getTitle() {
			return this.title;
		}
		public void setTitle(String title) {
			this.title = title;
		}

}


}