package com.taobao.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.PromotionmiscActivityRangeRemoveResponse;

/**
 * TOP API: taobao.promotionmisc.activity.range.remove request
 * 
 * @author top auto create
 * @since 1.0, 2022.04.28
 */
public class PromotionmiscActivityRangeRemoveRequest extends BaseTaobaoRequest<PromotionmiscActivityRangeRemoveResponse> {
	
	

	/** 
	* 活动id。
	 */
	private Long activityId;

	/** 
	* 商品id,多个id用逗号隔开。
	 */
	private String ids;

	public void setActivityId(Long activityId) {
		this.activityId = activityId;
	}

	public Long getActivityId() {
		return this.activityId;
	}

	public void setIds(String ids) {
		this.ids = ids;
	}

	public String getIds() {
		return this.ids;
	}

	public String getApiMethodName() {
		return "taobao.promotionmisc.activity.range.remove";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("activity_id", this.activityId);
		txtParams.put("ids", this.ids);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<PromotionmiscActivityRangeRemoveResponse> getResponseClass() {
		return PromotionmiscActivityRangeRemoveResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(activityId, "activityId");
		RequestCheckUtils.checkNotEmpty(ids, "ids");
	}
	

}