package com.taobao.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Date;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.PromotionmiscItemActivityUpdateResponse;

/**
 * TOP API: taobao.promotionmisc.item.activity.update request
 * 
 * @author top auto create
 * @since 1.0, 2022.04.28
 */
public class PromotionmiscItemActivityUpdateRequest extends BaseTaobaoRequest<PromotionmiscItemActivityUpdateResponse> {
	
	

	/** 
	* 活动id。
	 */
	private Long activityId;

	/** 
	* 减多少钱。当is_decrease_money为true时，该值才有意义。注意：该值单位为分，即100表示1元。
	 */
	private Long decreaseAmount;

	/** 
	* 折扣值。当is_discount为true时，该值才有意义。注意：800表示8折。
	 */
	private Long discountRate;

	/** 
	* 活动结束时间。
	 */
	private Date endTime;

	/** 
	* 是否有减钱行为。
	 */
	private Boolean isDecreaseMoney;

	/** 
	* 是否有打折行为。
	 */
	private Boolean isDiscount;

	/** 
	* 是否指定用户标签。
	 */
	private Boolean isUserTag;

	/** 
	* 活动名称。
	 */
	private String name;

	/** 
	* 活动范围：0表示全部参与； 1表示部分商品参与。
	 */
	private Long participateRange;

	/** 
	* 活动开始时间。
	 */
	private Date startTime;

	/** 
	* 用户标签。当is_user_tag为true时，该值才有意义。
	 */
	private String userTag;

	public void setActivityId(Long activityId) {
		this.activityId = activityId;
	}

	public Long getActivityId() {
		return this.activityId;
	}

	public void setDecreaseAmount(Long decreaseAmount) {
		this.decreaseAmount = decreaseAmount;
	}

	public Long getDecreaseAmount() {
		return this.decreaseAmount;
	}

	public void setDiscountRate(Long discountRate) {
		this.discountRate = discountRate;
	}

	public Long getDiscountRate() {
		return this.discountRate;
	}

	public void setEndTime(Date endTime) {
		this.endTime = endTime;
	}

	public Date getEndTime() {
		return this.endTime;
	}

	public void setIsDecreaseMoney(Boolean isDecreaseMoney) {
		this.isDecreaseMoney = isDecreaseMoney;
	}

	public Boolean getIsDecreaseMoney() {
		return this.isDecreaseMoney;
	}

	public void setIsDiscount(Boolean isDiscount) {
		this.isDiscount = isDiscount;
	}

	public Boolean getIsDiscount() {
		return this.isDiscount;
	}

	public void setIsUserTag(Boolean isUserTag) {
		this.isUserTag = isUserTag;
	}

	public Boolean getIsUserTag() {
		return this.isUserTag;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getName() {
		return this.name;
	}

	public void setParticipateRange(Long participateRange) {
		this.participateRange = participateRange;
	}

	public Long getParticipateRange() {
		return this.participateRange;
	}

	public void setStartTime(Date startTime) {
		this.startTime = startTime;
	}

	public Date getStartTime() {
		return this.startTime;
	}

	public void setUserTag(String userTag) {
		this.userTag = userTag;
	}

	public String getUserTag() {
		return this.userTag;
	}

	public String getApiMethodName() {
		return "taobao.promotionmisc.item.activity.update";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("activity_id", this.activityId);
		txtParams.put("decrease_amount", this.decreaseAmount);
		txtParams.put("discount_rate", this.discountRate);
		txtParams.put("end_time", this.endTime);
		txtParams.put("is_decrease_money", this.isDecreaseMoney);
		txtParams.put("is_discount", this.isDiscount);
		txtParams.put("is_user_tag", this.isUserTag);
		txtParams.put("name", this.name);
		txtParams.put("participate_range", this.participateRange);
		txtParams.put("start_time", this.startTime);
		txtParams.put("user_tag", this.userTag);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<PromotionmiscItemActivityUpdateResponse> getResponseClass() {
		return PromotionmiscItemActivityUpdateResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(activityId, "activityId");
		RequestCheckUtils.checkNotEmpty(endTime, "endTime");
		RequestCheckUtils.checkNotEmpty(name, "name");
		RequestCheckUtils.checkMaxLength(name, 32, "name");
		RequestCheckUtils.checkNotEmpty(participateRange, "participateRange");
		RequestCheckUtils.checkNotEmpty(startTime, "startTime");
	}
	

}