package com.taobao.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.PromotionmiscMjsActivityGetResponse;

/**
 * TOP API: taobao.promotionmisc.mjs.activity.get request
 * 
 * @author top auto create
 * @since 1.0, 2022.05.23
 */
public class PromotionmiscMjsActivityGetRequest extends BaseTaobaoRequest<PromotionmiscMjsActivityGetResponse> {
	
	

	/** 
	* 活动id。
	 */
	private Long activityId;

	public void setActivityId(Long activityId) {
		this.activityId = activityId;
	}

	public Long getActivityId() {
		return this.activityId;
	}

	public String getApiMethodName() {
		return "taobao.promotionmisc.mjs.activity.get";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("activity_id", this.activityId);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<PromotionmiscMjsActivityGetResponse> getResponseClass() {
		return PromotionmiscMjsActivityGetResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(activityId, "activityId");
	}
	

}