package com.taobao.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.PromotionmiscToolCheckResponse;

/**
 * TOP API: taobao.promotionmisc.tool.check request
 * 
 * @author top auto create
 * @since 1.0, 2018.07.25
 */
public class PromotionmiscToolCheckRequest extends BaseTaobaoRequest<PromotionmiscToolCheckResponse> {
	
	

	/** 
	* 可使用的元数据。PRD审核后，会告诉isv可使用的元数据。
	 */
	private String metaAllow;

	/** 
	* 工具ID, taobao.ump.tool.add成功后返回的id。
	 */
	private Long toolId;

	public void setMetaAllow(String metaAllow) {
		this.metaAllow = metaAllow;
	}

	public String getMetaAllow() {
		return this.metaAllow;
	}

	public void setToolId(Long toolId) {
		this.toolId = toolId;
	}

	public Long getToolId() {
		return this.toolId;
	}

	public String getApiMethodName() {
		return "taobao.promotionmisc.tool.check";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("meta_allow", this.metaAllow);
		txtParams.put("tool_id", this.toolId);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<PromotionmiscToolCheckResponse> getResponseClass() {
		return PromotionmiscToolCheckResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(toolId, "toolId");
		RequestCheckUtils.checkMinValue(toolId, 10L, "toolId");
	}
	

}