package com.taobao.api.request;

import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.util.RequestCheckUtils;
import com.taobao.api.TaobaoObject;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.json.JSONWriter;
import com.taobao.api.response.TmallItempromotionActivityGetResponse;

/**
 * TOP API: tmall.itempromotion.activity.get request
 * 
 * @author top auto create
 * @since 1.0, 2022.04.28
 */
public class TmallItempromotionActivityGetRequest extends BaseTaobaoRequest<TmallItempromotionActivityGetResponse> {
	
	

	/** 
	* 来源应用信息
	 */
	private String appInfo;

	/** 
	* 活动id
	 */
	private Long campaignId;

	public void setAppInfo(String appInfo) {
		this.appInfo = appInfo;
	}

	public void setAppInfo(AppInfo appInfo) {
		this.appInfo = new JSONWriter(false,true).write(appInfo);
	}

	public String getAppInfo() {
		return this.appInfo;
	}

	public void setCampaignId(Long campaignId) {
		this.campaignId = campaignId;
	}

	public Long getCampaignId() {
		return this.campaignId;
	}

	public String getApiMethodName() {
		return "tmall.itempromotion.activity.get";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("app_info", this.appInfo);
		txtParams.put("campaign_id", this.campaignId);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<TmallItempromotionActivityGetResponse> getResponseClass() {
		return TmallItempromotionActivityGetResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(campaignId, "campaignId");
	}
	
	/**
 * 来源应用信息
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class AppInfo extends TaobaoObject {

	private static final long serialVersionUID = 2562541441867918569L;

	/**
		 * 应用名称
		 */
		@ApiField("app_name")
		private String appName;
	

	public String getAppName() {
			return this.appName;
		}
		public void setAppName(String appName) {
			this.appName = appName;
		}

}


}