package com.taobao.api.request;

import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.mapping.ApiListField;
import com.taobao.api.TaobaoObject;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.json.JSONWriter;
import com.taobao.api.response.TmallItempromotionItemCreateResponse;

/**
 * TOP API: tmall.itempromotion.item.create request
 * 
 * @author top auto create
 * @since 1.0, 2022.04.28
 */
public class TmallItempromotionItemCreateRequest extends BaseTaobaoRequest<TmallItempromotionItemCreateResponse> {
	
	

	/** 
	* 来源信息
	 */
	private String appInfo;

	/** 
	* 报名商品入参
	 */
	private String itemPromotionDto;

	public void setAppInfo(String appInfo) {
		this.appInfo = appInfo;
	}

	public void setAppInfo(AppInfo appInfo) {
		this.appInfo = new JSONWriter(false,true).write(appInfo);
	}

	public String getAppInfo() {
		return this.appInfo;
	}

	public void setItemPromotionDto(String itemPromotionDto) {
		this.itemPromotionDto = itemPromotionDto;
	}

	public void setItemPromotionDto(ItemPromotionDto itemPromotionDto) {
		this.itemPromotionDto = new JSONWriter(false,true).write(itemPromotionDto);
	}

	public String getItemPromotionDto() {
		return this.itemPromotionDto;
	}

	public String getApiMethodName() {
		return "tmall.itempromotion.item.create";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("app_info", this.appInfo);
		txtParams.put("item_promotion_dto", this.itemPromotionDto);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<TmallItempromotionItemCreateResponse> getResponseClass() {
		return TmallItempromotionItemCreateResponse.class;
	}

	public void check() throws ApiRuleException {
	}
	
	/**
 * 商品级别报名时需要传递，sku报名不需要传递
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class PromUnitDto extends TaobaoObject {

	private static final long serialVersionUID = 1584571489532723748L;

	/**
		 * 商品级别优惠价格，单位分
		 */
		@ApiField("discount")
		private Long discount;
	

	public Long getDiscount() {
			return this.discount;
		}
		public void setDiscount(Long discount) {
			this.discount = discount;
		}

}

	/**
 * 设置限购信息，商品级别报名可选，sku级别报名一定不要设置
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class Features extends TaobaoObject {

	private static final long serialVersionUID = 6522449929127728145L;

	/**
		 * 优惠总量限购
		 */
		@ApiField("item_promotion_item_limit")
		private String itemPromotionItemLimit;
		/**
		 * 每人优惠限购
		 */
		@ApiField("item_promotion_user_limit")
		private String itemPromotionUserLimit;
	

	public String getItemPromotionItemLimit() {
			return this.itemPromotionItemLimit;
		}
		public void setItemPromotionItemLimit(String itemPromotionItemLimit) {
			this.itemPromotionItemLimit = itemPromotionItemLimit;
		}
		public String getItemPromotionUserLimit() {
			return this.itemPromotionUserLimit;
		}
		public void setItemPromotionUserLimit(String itemPromotionUserLimit) {
			this.itemPromotionUserLimit = itemPromotionUserLimit;
		}

}

	/**
 * sku级别报名时必选
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class SkuPromUnitDto extends TaobaoObject {

	private static final long serialVersionUID = 3621384226655485979L;

	/**
		 * sku价格，单位分
		 */
		@ApiField("discount")
		private Long discount;
		/**
		 * skuId
		 */
		@ApiField("sku_id")
		private Long skuId;
	

	public Long getDiscount() {
			return this.discount;
		}
		public void setDiscount(Long discount) {
			this.discount = discount;
		}
		public Long getSkuId() {
			return this.skuId;
		}
		public void setSkuId(Long skuId) {
			this.skuId = skuId;
		}

}

	/**
 * 报名商品入参
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class ItemPromotionDto extends TaobaoObject {

	private static final long serialVersionUID = 5278872662627672393L;

	/**
		 * 活动id
		 */
		@ApiField("campaign_id")
		private Long campaignId;
		/**
		 * 设置限购信息，商品级别报名可选，sku级别报名一定不要设置
		 */
		@ApiField("features")
		private Features features;
		/**
		 * 商品id
		 */
		@ApiField("item_id")
		private Long itemId;
		/**
		 * 商品级别报名时需要传递，sku报名不需要传递
		 */
		@ApiField("item_level_prom")
		private PromUnitDto itemLevelProm;
		/**
		 * sku级别报名时必选
		 */
		@ApiListField("sku_level_proms")
		@ApiField("sku_prom_unit_dto")
		private List<SkuPromUnitDto> skuLevelProms;
	

	public Long getCampaignId() {
			return this.campaignId;
		}
		public void setCampaignId(Long campaignId) {
			this.campaignId = campaignId;
		}
		public Features getFeatures() {
			return this.features;
		}
		public void setFeatures(Features features) {
			this.features = features;
		}
		public Long getItemId() {
			return this.itemId;
		}
		public void setItemId(Long itemId) {
			this.itemId = itemId;
		}
		public PromUnitDto getItemLevelProm() {
			return this.itemLevelProm;
		}
		public void setItemLevelProm(PromUnitDto itemLevelProm) {
			this.itemLevelProm = itemLevelProm;
		}
		public List<SkuPromUnitDto> getSkuLevelProms() {
			return this.skuLevelProms;
		}
		public void setSkuLevelProms(List<SkuPromUnitDto> skuLevelProms) {
			this.skuLevelProms = skuLevelProms;
		}

}

	/**
 * 来源信息
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class AppInfo extends TaobaoObject {

	private static final long serialVersionUID = 5434928913462821655L;

	/**
		 * 应用名
		 */
		@ApiField("app_name")
		private String appName;
	

	public String getAppName() {
			return this.appName;
		}
		public void setAppName(String appName) {
			this.appName = appName;
		}

}


}