package com.taobao.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Date;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.TmallPromotagTagDelaytagResponse;

/**
 * TOP API: tmall.promotag.tag.delaytag request
 * 
 * @author top auto create
 * @since 1.0, 2022.07.18
 */
public class TmallPromotagTagDelaytagRequest extends BaseTaobaoRequest<TmallPromotagTagDelaytagResponse> {
	
	

	/** 
	* 延期至的时间戳
	 */
	private Date endTime;

	/** 
	* 需要延期的 tag ID
	 */
	private Long tagId;

	public void setEndTime(Date endTime) {
		this.endTime = endTime;
	}

	public Date getEndTime() {
		return this.endTime;
	}

	public void setTagId(Long tagId) {
		this.tagId = tagId;
	}

	public Long getTagId() {
		return this.tagId;
	}

	public String getApiMethodName() {
		return "tmall.promotag.tag.delaytag";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("end_time", this.endTime);
		txtParams.put("tag_id", this.tagId);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<TmallPromotagTagDelaytagResponse> getResponseClass() {
		return TmallPromotagTagDelaytagResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(endTime, "endTime");
		RequestCheckUtils.checkNotEmpty(tagId, "tagId");
	}
	

}