package com.taobao.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import com.taobao.api.internal.util.json.JSONValidatingReader;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.TmallPromotionCouponQueryResponse;

/**
 * TOP API: tmall.promotion.coupon.query request
 * 
 * @author top auto create
 * @since 1.0, 2022.04.28
 */
public class TmallPromotionCouponQueryRequest extends BaseTaobaoRequest<TmallPromotionCouponQueryResponse> {
	
	

	/** 
	* 业务类型
	 */
	private String bizType;

	/** 
	* buyer_id、buyer_nick至少填一个， 都填写以id为准
	 */
	private String buyerId;

	/** 
	* buyer_id、buyer_nick至少填一个， 都填写以id为准
	 */
	private String buyerNick;

	/** 
	* 扩展字段
	 */
	private String extra;

	public void setBizType(String bizType) {
		this.bizType = bizType;
	}

	public String getBizType() {
		return this.bizType;
	}

	public void setBuyerId(String buyerId) {
		this.buyerId = buyerId;
	}

	public String getBuyerId() {
		return this.buyerId;
	}

	public void setBuyerNick(String buyerNick) {
		this.buyerNick = buyerNick;
	}

	public String getBuyerNick() {
		return this.buyerNick;
	}

	public void setExtra(String extra) {
		this.extra = extra;
	}
	public void setExtraString(String extra) {
		this.extra = extra;
	}

	public String getExtra() {
		return this.extra;
	}

	public String getApiMethodName() {
		return "tmall.promotion.coupon.query";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("biz_type", this.bizType);
		txtParams.put("buyer_id", this.buyerId);
		txtParams.put("buyer_nick", this.buyerNick);
		txtParams.put("extra", this.extra);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<TmallPromotionCouponQueryResponse> getResponseClass() {
		return TmallPromotionCouponQueryResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(bizType, "bizType");
	}
	

}