package com.taobao.api.request;

import com.taobao.api.internal.util.json.JSONValidatingReader;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.TmallPromotionCouponUserResponse;

/**
 * TOP API: tmall.promotion.coupon.user request
 * 
 * @author top auto create
 * @since 1.0, 2022.04.28
 */
public class TmallPromotionCouponUserRequest extends BaseTaobaoRequest<TmallPromotionCouponUserResponse> {
	
	

	/** 
	* 例如：suning
	 */
	private String bizType;

	/** 
	* 扩展字段
	 */
	private String extra;

	/** 
	* 会员付款码
	 */
	private String payCode;

	public void setBizType(String bizType) {
		this.bizType = bizType;
	}

	public String getBizType() {
		return this.bizType;
	}

	public void setExtra(String extra) {
		this.extra = extra;
	}
	public void setExtraString(String extra) {
		this.extra = extra;
	}

	public String getExtra() {
		return this.extra;
	}

	public void setPayCode(String payCode) {
		this.payCode = payCode;
	}

	public String getPayCode() {
		return this.payCode;
	}

	public String getApiMethodName() {
		return "tmall.promotion.coupon.user";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("biz_type", this.bizType);
		txtParams.put("extra", this.extra);
		txtParams.put("pay_code", this.payCode);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<TmallPromotionCouponUserResponse> getResponseClass() {
		return TmallPromotionCouponUserResponse.class;
	}

	public void check() throws ApiRuleException {
	}
	

}