package com.taobao.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.UmpActivityUpdateResponse;

/**
 * TOP API: taobao.ump.activity.update request
 * 
 * @author top auto create
 * @since 1.0, 2022.04.28
 */
public class UmpActivityUpdateRequest extends BaseTaobaoRequest<UmpActivityUpdateResponse> {
	
	

	/** 
	* 活动id
	 */
	private Long actId;

	/** 
	* 营销活动内容，json格式，通过ump sdk 的marketingTool来生成
	 */
	private String content;

	public void setActId(Long actId) {
		this.actId = actId;
	}

	public Long getActId() {
		return this.actId;
	}

	public void setContent(String content) {
		this.content = content;
	}

	public String getContent() {
		return this.content;
	}

	public String getApiMethodName() {
		return "taobao.ump.activity.update";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("act_id", this.actId);
		txtParams.put("content", this.content);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<UmpActivityUpdateResponse> getResponseClass() {
		return UmpActivityUpdateResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(actId, "actId");
		RequestCheckUtils.checkNotEmpty(content, "content");
	}
	

}