package com.taobao.api.request;

import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.TaobaoObject;
import java.util.Date;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.json.JSONWriter;
import com.taobao.api.response.UmpBenefittemplateOrightQueryResponse;

/**
 * TOP API: taobao.ump.benefittemplate.oright.query request
 * 
 * @author top auto create
 * @since 1.0, 2023.03.22
 */
public class UmpBenefittemplateOrightQueryRequest extends BaseTaobaoRequest<UmpBenefittemplateOrightQueryResponse> {
	
	

	/** 
	* 查询入参
	 */
	private String orightReqDto;

	public void setOrightReqDto(String orightReqDto) {
		this.orightReqDto = orightReqDto;
	}

	public void setOrightReqDto(OrightReqDTO orightReqDto) {
		this.orightReqDto = new JSONWriter(false,true).write(orightReqDto);
	}

	public String getOrightReqDto() {
		return this.orightReqDto;
	}

	public String getApiMethodName() {
		return "taobao.ump.benefittemplate.oright.query";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("oright_req_dto", this.orightReqDto);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<UmpBenefittemplateOrightQueryResponse> getResponseClass() {
		return UmpBenefittemplateOrightQueryResponse.class;
	}

	public void check() throws ApiRuleException {
	}
	
	/**
 * 查询入参
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class QueryTemplateReqDTO extends TaobaoObject {

	private static final long serialVersionUID = 3741736428455955532L;

	/**
		 * 当前页
		 */
		@ApiField("current_page")
		private Long currentPage;
		/**
		 * 操作人所属账号体系
		 */
		@ApiField("op_acct_sys")
		private String opAcctSys;
		/**
		 * 操作人ID
		 */
		@ApiField("operator_id")
		private Long operatorId;
		/**
		 * 单页大小
		 */
		@ApiField("page_size")
		private Long pageSize;
		/**
		 * 产品code
		 */
		@ApiField("product_code")
		private String productCode;
		/**
		 * 模板创建人ID
		 */
		@ApiField("provider_id")
		private Long providerId;
		/**
		 * 模板ID
		 */
		@ApiField("template_id")
		private Long templateId;
	

	public Long getCurrentPage() {
			return this.currentPage;
		}
		public void setCurrentPage(Long currentPage) {
			this.currentPage = currentPage;
		}
		public String getOpAcctSys() {
			return this.opAcctSys;
		}
		public void setOpAcctSys(String opAcctSys) {
			this.opAcctSys = opAcctSys;
		}
		public Long getOperatorId() {
			return this.operatorId;
		}
		public void setOperatorId(Long operatorId) {
			this.operatorId = operatorId;
		}
		public Long getPageSize() {
			return this.pageSize;
		}
		public void setPageSize(Long pageSize) {
			this.pageSize = pageSize;
		}
		public String getProductCode() {
			return this.productCode;
		}
		public void setProductCode(String productCode) {
			this.productCode = productCode;
		}
		public Long getProviderId() {
			return this.providerId;
		}
		public void setProviderId(Long providerId) {
			this.providerId = providerId;
		}
		public Long getTemplateId() {
			return this.templateId;
		}
		public void setTemplateId(Long templateId) {
			this.templateId = templateId;
		}

}

	/**
 * 调用信息
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class InvokeInfoDTO extends TaobaoObject {

	private static final long serialVersionUID = 8589745938313911814L;

	/**
		 * 调用方的应用名
		 */
		@ApiField("app_name")
		private String appName;
		/**
		 * 调用时间点
		 */
		@ApiField("invoke_time")
		private Date invokeTime;
	

	public String getAppName() {
			return this.appName;
		}
		public void setAppName(String appName) {
			this.appName = appName;
		}
		public Date getInvokeTime() {
			return this.invokeTime;
		}
		public void setInvokeTime(Date invokeTime) {
			this.invokeTime = invokeTime;
		}

}

	/**
 * 查询入参
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class OrightReqDTO extends TaobaoObject {

	private static final long serialVersionUID = 6764431239771695777L;

	/**
		 * 调用信息
		 */
		@ApiField("invoke_info")
		private InvokeInfoDTO invokeInfo;
		/**
		 * 查询入参
		 */
		@ApiField("param")
		private QueryTemplateReqDTO param;
	

	public InvokeInfoDTO getInvokeInfo() {
			return this.invokeInfo;
		}
		public void setInvokeInfo(InvokeInfoDTO invokeInfo) {
			this.invokeInfo = invokeInfo;
		}
		public QueryTemplateReqDTO getParam() {
			return this.param;
		}
		public void setParam(QueryTemplateReqDTO param) {
			this.param = param;
		}

}


}