package com.taobao.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.UmpDetailDeleteResponse;

/**
 * TOP API: taobao.ump.detail.delete request
 * 
 * @author top auto create
 * @since 1.0, 2022.04.28
 */
public class UmpDetailDeleteRequest extends BaseTaobaoRequest<UmpDetailDeleteResponse> {
	
	

	/** 
	* 活动详情id
	 */
	private Long detailId;

	public void setDetailId(Long detailId) {
		this.detailId = detailId;
	}

	public Long getDetailId() {
		return this.detailId;
	}

	public String getApiMethodName() {
		return "taobao.ump.detail.delete";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("detail_id", this.detailId);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<UmpDetailDeleteResponse> getResponseClass() {
		return UmpDetailDeleteResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(detailId, "detailId");
	}
	

}