package com.taobao.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.UmpMbbGetbyidResponse;

/**
 * TOP API: taobao.ump.mbb.getbyid request
 * 
 * @author top auto create
 * @since 1.0, 2022.09.17
 */
public class UmpMbbGetbyidRequest extends BaseTaobaoRequest<UmpMbbGetbyidResponse> {
	
	

	/** 
	* 积木块的id
	 */
	private Long id;

	public void setId(Long id) {
		this.id = id;
	}

	public Long getId() {
		return this.id;
	}

	public String getApiMethodName() {
		return "taobao.ump.mbb.getbyid";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("id", this.id);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<UmpMbbGetbyidResponse> getResponseClass() {
		return UmpMbbGetbyidResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(id, "id");
	}
	

}