package com.taobao.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.UmpPromotionSkuGetResponse;

/**
 * TOP API: taobao.ump.promotion.sku.get request
 * 
 * @author top auto create
 * @since 1.0, 2022.04.08
 */
public class UmpPromotionSkuGetRequest extends BaseTaobaoRequest<UmpPromotionSkuGetResponse> {
	
	

	/** 
	* 买家id
	 */
	private String buyerId;

	/** 
	* 渠道
	 */
	private String channelKey;

	/** 
	* 商品id
	 */
	private Long itemId;

	/** 
	* skuId
	 */
	private String skuList;

	public void setBuyerId(String buyerId) {
		this.buyerId = buyerId;
	}

	public String getBuyerId() {
		return this.buyerId;
	}

	public void setChannelKey(String channelKey) {
		this.channelKey = channelKey;
	}

	public String getChannelKey() {
		return this.channelKey;
	}

	public void setItemId(Long itemId) {
		this.itemId = itemId;
	}

	public Long getItemId() {
		return this.itemId;
	}

	public void setSkuList(String skuList) {
		this.skuList = skuList;
	}

	public String getSkuList() {
		return this.skuList;
	}

	public String getApiMethodName() {
		return "taobao.ump.promotion.sku.get";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("buyer_id", this.buyerId);
		txtParams.put("channel_key", this.channelKey);
		txtParams.put("item_id", this.itemId);
		txtParams.put("sku_list", this.skuList);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<UmpPromotionSkuGetResponse> getResponseClass() {
		return UmpPromotionSkuGetResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(itemId, "itemId");
	}
	

}