package com.taobao.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.UmpRangeAddResponse;

/**
 * TOP API: taobao.ump.range.add request
 * 
 * @author top auto create
 * @since 1.0, 2022.04.28
 */
public class UmpRangeAddRequest extends BaseTaobaoRequest<UmpRangeAddResponse> {
	
	

	/** 
	* 活动id
	 */
	private Long actId;

	/** 
	* id列表，当范围类型为商品时，该id为商品id.多个id用逗号隔开，一次不超过50个
	 */
	private String ids;

	/** 
	* 范围的类型，比如是全店，商品，见：MarketingConstants.PARTICIPATE_TYPE_*
	 */
	private Long type;

	public void setActId(Long actId) {
		this.actId = actId;
	}

	public Long getActId() {
		return this.actId;
	}

	public void setIds(String ids) {
		this.ids = ids;
	}

	public String getIds() {
		return this.ids;
	}

	public void setType(Long type) {
		this.type = type;
	}

	public Long getType() {
		return this.type;
	}

	public String getApiMethodName() {
		return "taobao.ump.range.add";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("act_id", this.actId);
		txtParams.put("ids", this.ids);
		txtParams.put("type", this.type);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<UmpRangeAddResponse> getResponseClass() {
		return UmpRangeAddResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(actId, "actId");
		RequestCheckUtils.checkNotEmpty(ids, "ids");
		RequestCheckUtils.checkNotEmpty(type, "type");
	}
	

}