package com.taobao.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.UmpRangeGetResponse;

/**
 * TOP API: taobao.ump.range.get request
 * 
 * @author top auto create
 * @since 1.0, 2022.05.24
 */
public class UmpRangeGetRequest extends BaseTaobaoRequest<UmpRangeGetResponse> {
	
	

	/** 
	* 活动id
	 */
	private Long actId;

	public void setActId(Long actId) {
		this.actId = actId;
	}

	public Long getActId() {
		return this.actId;
	}

	public String getApiMethodName() {
		return "taobao.ump.range.get";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("act_id", this.actId);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<UmpRangeGetResponse> getResponseClass() {
		return UmpRangeGetResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(actId, "actId");
	}
	

}