package com.taobao.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.UmpToolAddResponse;

/**
 * TOP API: taobao.ump.tool.add request
 * 
 * @author top auto create
 * @since 1.0, 2022.09.17
 */
public class UmpToolAddRequest extends BaseTaobaoRequest<UmpToolAddResponse> {
	
	

	/** 
	* 工具内容，由sdk里面的MarketingTool生成的json字符串
	 */
	private String content;

	public void setContent(String content) {
		this.content = content;
	}

	public String getContent() {
		return this.content;
	}

	public String getApiMethodName() {
		return "taobao.ump.tool.add";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("content", this.content);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<UmpToolAddResponse> getResponseClass() {
		return UmpToolAddResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(content, "content");
	}
	

}