package com.taobao.api.request;

import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.UmpToolsGetResponse;

/**
 * TOP API: taobao.ump.tools.get request
 * 
 * @author top auto create
 * @since 1.0, 2022.09.17
 */
public class UmpToolsGetRequest extends BaseTaobaoRequest<UmpToolsGetResponse> {
	
	

	/** 
	* 工具编码
	 */
	private String toolCode;

	public void setToolCode(String toolCode) {
		this.toolCode = toolCode;
	}

	public String getToolCode() {
		return this.toolCode;
	}

	public String getApiMethodName() {
		return "taobao.ump.tools.get";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("tool_code", this.toolCode);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<UmpToolsGetResponse> getResponseClass() {
		return UmpToolsGetResponse.class;
	}

	public void check() throws ApiRuleException {
	}
	

}