package com.taobao.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Date;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.UppShoppointO2oSendResponse;

/**
 * TOP API: taobao.upp.shoppoint.o2o.send request
 * 
 * @author top auto create
 * @since 1.0, 2014.11.20
 */
public class UppShoppointO2oSendRequest extends BaseTaobaoRequest<UppShoppointO2oSendResponse> {
	
	

	/** 
	* 买家nick
	 */
	private String buyerNick;

	/** 
	* 处理的店铺积分数量
	 */
	private Long pointNum;

	/** 
	* 用于实际发放的时候关联系统发放记录，由预发放接口返回
	 */
	private Long transactionId;

	/** 
	* 6:业务成功
4:业务失败
	 */
	private Long transactionStatus;

	/** 
	* 业务发生的时间
	 */
	private Date transactionTime;

	public void setBuyerNick(String buyerNick) {
		this.buyerNick = buyerNick;
	}

	public String getBuyerNick() {
		return this.buyerNick;
	}

	public void setPointNum(Long pointNum) {
		this.pointNum = pointNum;
	}

	public Long getPointNum() {
		return this.pointNum;
	}

	public void setTransactionId(Long transactionId) {
		this.transactionId = transactionId;
	}

	public Long getTransactionId() {
		return this.transactionId;
	}

	public void setTransactionStatus(Long transactionStatus) {
		this.transactionStatus = transactionStatus;
	}

	public Long getTransactionStatus() {
		return this.transactionStatus;
	}

	public void setTransactionTime(Date transactionTime) {
		this.transactionTime = transactionTime;
	}

	public Date getTransactionTime() {
		return this.transactionTime;
	}

	public String getApiMethodName() {
		return "taobao.upp.shoppoint.o2o.send";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("buyer_nick", this.buyerNick);
		txtParams.put("point_num", this.pointNum);
		txtParams.put("transaction_id", this.transactionId);
		txtParams.put("transaction_status", this.transactionStatus);
		txtParams.put("transaction_time", this.transactionTime);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<UppShoppointO2oSendResponse> getResponseClass() {
		return UppShoppointO2oSendResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(buyerNick, "buyerNick");
		RequestCheckUtils.checkNotEmpty(pointNum, "pointNum");
		RequestCheckUtils.checkNotEmpty(transactionId, "transactionId");
		RequestCheckUtils.checkNotEmpty(transactionStatus, "transactionStatus");
		RequestCheckUtils.checkNotEmpty(transactionTime, "transactionTime");
	}
	

}