package com.taobao.api.response;

import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.util.json.JSONValidatingReader;
import com.taobao.api.internal.mapping.ApiListField;
import com.taobao.api.TaobaoObject;
import java.util.Date;

import com.taobao.api.TaobaoResponse;

/**
 * TOP API: alibaba.lafite.seller.benefit.list response.
 * 
 * @author top auto create
 * @since 1.0, null
 */
public class AlibabaLafiteSellerBenefitListResponse extends TaobaoResponse {

	private static final long serialVersionUID = 2583696372477757939L;

	/** 
	 * 接口返回model
	 */
	@ApiField("result")
	private Result result;


	public void setResult(Result result) {
		this.result = result;
	}
	public Result getResult( ) {
		return this.result;
	}
	
	/**
 * 返回查询数据
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class BenefitDto extends TaobaoObject {

	private static final long serialVersionUID = 2116627254819291855L;

	/**
		 * 关联的权益池id
		 */
		@ApiField("benefit_pool_id")
		private Long benefitPoolId;
		/**
		 * 发放量，当sendMode是fixedAmount时表示已发放个数，当sendMode为dynamicAmount时表示已发放面额，单位为分
		 */
		@ApiField("bestow")
		private Long bestow;
		/**
		 * 权益code
		 */
		@ApiField("code")
		private String code;
		/**
		 * 创建者昵称
		 */
		@ApiField("creator_user_name")
		private String creatorUserName;
		/**
		 * 权益描述
		 */
		@ApiField("description")
		private String description;
		/**
		 * 权益发放结束时间
		 */
		@ApiField("end_date")
		private Date endDate;
		/**
		 * 扩展字段
		 */
		@ApiField("feature")
		private String feature;
		/**
		 * 创建时间
		 */
		@ApiField("gmt_create")
		private Date gmtCreate;
		/**
		 * 修改时间
		 */
		@ApiField("gmt_modified")
		private Date gmtModified;
		/**
		 * 权益id
		 */
		@ApiField("id")
		private Long id;
		/**
		 * 修改者昵称
		 */
		@ApiField("modifier_user_name")
		private String modifierUserName;
		/**
		 * 权益名称
		 */
		@ApiField("name")
		private String name;
		/**
		 * 发放模式,fixedAmount,dynamicAmount
		 */
		@ApiField("send_mode")
		private String sendMode;
		/**
		 * 权益发放开始时间
		 */
		@ApiField("start_date")
		private Date startDate;
		/**
		 * 状态,online,offline,invalid
		 */
		@ApiField("status")
		private String status;
		/**
		 * 权益库存总数，当sendMode是fixedAmount时表示总库存个数，当sendMode为dynamicAmount时表示库存总面额，单位为分
		 */
		@ApiField("total")
		private Long total;
		/**
		 * 总个数，当sendMode为dynamicAmount时表示已发放面额，单位为分
		 */
		@ApiField("total_num")
		private Long totalNum;
		/**
		 * 权益类型
		 */
		@ApiField("type")
		private String type;
	

	public Long getBenefitPoolId() {
			return this.benefitPoolId;
		}
		public void setBenefitPoolId(Long benefitPoolId) {
			this.benefitPoolId = benefitPoolId;
		}
		public Long getBestow() {
			return this.bestow;
		}
		public void setBestow(Long bestow) {
			this.bestow = bestow;
		}
		public String getCode() {
			return this.code;
		}
		public void setCode(String code) {
			this.code = code;
		}
		public String getCreatorUserName() {
			return this.creatorUserName;
		}
		public void setCreatorUserName(String creatorUserName) {
			this.creatorUserName = creatorUserName;
		}
		public String getDescription() {
			return this.description;
		}
		public void setDescription(String description) {
			this.description = description;
		}
		public Date getEndDate() {
			return this.endDate;
		}
		public void setEndDate(Date endDate) {
			this.endDate = endDate;
		}
		public String getFeature() {
			return this.feature;
		}
		public void setFeature(String feature) {
			this.feature = feature;
		}
		public void setFeatureString(String feature) {
			this.feature = feature;
		}
		
		public Date getGmtCreate() {
			return this.gmtCreate;
		}
		public void setGmtCreate(Date gmtCreate) {
			this.gmtCreate = gmtCreate;
		}
		public Date getGmtModified() {
			return this.gmtModified;
		}
		public void setGmtModified(Date gmtModified) {
			this.gmtModified = gmtModified;
		}
		public Long getId() {
			return this.id;
		}
		public void setId(Long id) {
			this.id = id;
		}
		public String getModifierUserName() {
			return this.modifierUserName;
		}
		public void setModifierUserName(String modifierUserName) {
			this.modifierUserName = modifierUserName;
		}
		public String getName() {
			return this.name;
		}
		public void setName(String name) {
			this.name = name;
		}
		public String getSendMode() {
			return this.sendMode;
		}
		public void setSendMode(String sendMode) {
			this.sendMode = sendMode;
		}
		public Date getStartDate() {
			return this.startDate;
		}
		public void setStartDate(Date startDate) {
			this.startDate = startDate;
		}
		public String getStatus() {
			return this.status;
		}
		public void setStatus(String status) {
			this.status = status;
		}
		public Long getTotal() {
			return this.total;
		}
		public void setTotal(Long total) {
			this.total = total;
		}
		public Long getTotalNum() {
			return this.totalNum;
		}
		public void setTotalNum(Long totalNum) {
			this.totalNum = totalNum;
		}
		public String getType() {
			return this.type;
		}
		public void setType(String type) {
			this.type = type;
		}

}

	/**
 * 返回查询结果
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class Page extends TaobaoObject {

	private static final long serialVersionUID = 4268314437129563853L;

	/**
		 * 当前页
		 */
		@ApiField("current_page")
		private Long currentPage;
		/**
		 * 返回查询数据
		 */
		@ApiListField("data_list")
		@ApiField("benefit_dto")
		private List<BenefitDto> dataList;
		/**
		 * 每页记录数
		 */
		@ApiField("page_size")
		private Long pageSize;
		/**
		 * 总记录数
		 */
		@ApiField("total_count")
		private Long totalCount;
	

	public Long getCurrentPage() {
			return this.currentPage;
		}
		public void setCurrentPage(Long currentPage) {
			this.currentPage = currentPage;
		}
		public List<BenefitDto> getDataList() {
			return this.dataList;
		}
		public void setDataList(List<BenefitDto> dataList) {
			this.dataList = dataList;
		}
		public Long getPageSize() {
			return this.pageSize;
		}
		public void setPageSize(Long pageSize) {
			this.pageSize = pageSize;
		}
		public Long getTotalCount() {
			return this.totalCount;
		}
		public void setTotalCount(Long totalCount) {
			this.totalCount = totalCount;
		}

}

	/**
 * 接口返回model
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class Result extends TaobaoObject {

	private static final long serialVersionUID = 5858876322249264694L;

	/**
		 * 错误码
		 */
		@ApiField("code")
		private String code;
		/**
		 * 返回查询结果
		 */
		@ApiField("data")
		private Page data;
		/**
		 * 错误信息
		 */
		@ApiField("msg")
		private String msg;
		/**
		 * 是否成功
		 */
		@ApiField("success")
		private Boolean success;
	

	public String getCode() {
			return this.code;
		}
		public void setCode(String code) {
			this.code = code;
		}
		public Page getData() {
			return this.data;
		}
		public void setData(Page data) {
			this.data = data;
		}
		public String getMsg() {
			return this.msg;
		}
		public void setMsg(String msg) {
			this.msg = msg;
		}
		public Boolean getSuccess() {
			return this.success;
		}
		public void setSuccess(Boolean success) {
			this.success = success;
		}

}



}
