package com.taobao.api.response;

import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.mapping.ApiListField;
import com.taobao.api.TaobaoObject;

import com.taobao.api.TaobaoResponse;

/**
 * TOP API: taobao.ju.hjsfeeds.get response.
 * 
 * @author top auto create
 * @since 1.0, null
 */
public class JuHjsfeedsGetResponse extends TaobaoResponse {

	private static final long serialVersionUID = 6843985469347737822L;

	/** 
	 * 当前页
	 */
	@ApiField("cur_page")
	private Long curPage;

	/** 
	 * 是否有下一页
	 */
	@ApiField("has_more")
	private Boolean hasMore;

	/** 
	 * 商品列表
	 */
	@ApiListField("items")
	@ApiField("items")
	private List<Items> items;

	/** 
	 * 一页的个数
	 */
	@ApiField("page_size")
	private Long pageSize;

	/** 
	 * 总页数
	 */
	@ApiField("total_page")
	private Long totalPage;


	public void setCurPage(Long curPage) {
		this.curPage = curPage;
	}
	public Long getCurPage( ) {
		return this.curPage;
	}

	public void setHasMore(Boolean hasMore) {
		this.hasMore = hasMore;
	}
	public Boolean getHasMore( ) {
		return this.hasMore;
	}

	public void setItems(List<Items> items) {
		this.items = items;
	}
	public List<Items> getItems( ) {
		return this.items;
	}

	public void setPageSize(Long pageSize) {
		this.pageSize = pageSize;
	}
	public Long getPageSize( ) {
		return this.pageSize;
	}

	public void setTotalPage(Long totalPage) {
		this.totalPage = totalPage;
	}
	public Long getTotalPage( ) {
		return this.totalPage;
	}
	
	/**
 * 商品列表
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class Items extends TaobaoObject {

	private static final long serialVersionUID = 3486174197734123717L;

	/**
		 * 活动价格
		 */
		@ApiField("activity_price")
		private String activityPrice;
		/**
		 * 商品利益点
		 */
		@ApiField("benefit_info")
		private String benefitInfo;
		/**
		 * 商品品牌名称
		 */
		@ApiField("brand_name")
		private String brandName;
		/**
		 * 获取佣金
		 */
		@ApiField("comm_amount")
		private String commAmount;
		/**
		 * 商品图片
		 */
		@ApiField("item_pic")
		private String itemPic;
		/**
		 * 商品状态
		 */
		@ApiField("item_status")
		private String itemStatus;
		/**
		 * 商品标题
		 */
		@ApiField("item_title")
		private String itemTitle;
		/**
		 * 商品原价
		 */
		@ApiField("original_price")
		private String originalPrice;
		/**
		 * 关注数
		 */
		@ApiField("remind_num")
		private String remindNum;
		/**
		 * 已售件数
		 */
		@ApiField("sold_count")
		private String soldCount;
	

	public String getActivityPrice() {
			return this.activityPrice;
		}
		public void setActivityPrice(String activityPrice) {
			this.activityPrice = activityPrice;
		}
		public String getBenefitInfo() {
			return this.benefitInfo;
		}
		public void setBenefitInfo(String benefitInfo) {
			this.benefitInfo = benefitInfo;
		}
		public String getBrandName() {
			return this.brandName;
		}
		public void setBrandName(String brandName) {
			this.brandName = brandName;
		}
		public String getCommAmount() {
			return this.commAmount;
		}
		public void setCommAmount(String commAmount) {
			this.commAmount = commAmount;
		}
		public String getItemPic() {
			return this.itemPic;
		}
		public void setItemPic(String itemPic) {
			this.itemPic = itemPic;
		}
		public String getItemStatus() {
			return this.itemStatus;
		}
		public void setItemStatus(String itemStatus) {
			this.itemStatus = itemStatus;
		}
		public String getItemTitle() {
			return this.itemTitle;
		}
		public void setItemTitle(String itemTitle) {
			this.itemTitle = itemTitle;
		}
		public String getOriginalPrice() {
			return this.originalPrice;
		}
		public void setOriginalPrice(String originalPrice) {
			this.originalPrice = originalPrice;
		}
		public String getRemindNum() {
			return this.remindNum;
		}
		public void setRemindNum(String remindNum) {
			this.remindNum = remindNum;
		}
		public String getSoldCount() {
			return this.soldCount;
		}
		public void setSoldCount(String soldCount) {
			this.soldCount = soldCount;
		}

}



}
