package com.taobao.api.response;

import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.util.json.JSONValidatingReader;
import com.taobao.api.internal.mapping.ApiListField;
import com.taobao.api.TaobaoObject;
import java.util.Date;

import com.taobao.api.TaobaoResponse;

/**
 * TOP API: taobao.ump.benefittemplate.oright.query response.
 * 
 * @author top auto create
 * @since 1.0, null
 */
public class UmpBenefittemplateOrightQueryResponse extends TaobaoResponse {

	private static final long serialVersionUID = 6551613971846959564L;

	/** 
	 * 结果
	 */
	@ApiField("result")
	private ResultSupport result;


	public void setResult(ResultSupport result) {
		this.result = result;
	}
	public ResultSupport getResult( ) {
		return this.result;
	}
	
	/**
 * 权益模板列表
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class TemplateDTO extends TaobaoObject {

	private static final long serialVersionUID = 4862431916711141165L;

	/**
		 * 模板创建审批链接
		 */
		@ApiField("create_approval_url")
		private String createApprovalUrl;
		/**
		 * 生效时间
		 */
		@ApiField("effect_time")
		private Date effectTime;
		/**
		 * 失效时间
		 */
		@ApiField("expire_time")
		private Date expireTime;
		/**
		 * 扩展属性
		 */
		@ApiField("features")
		private String features;
		/**
		 * 模板对应产品的表单code
		 */
		@ApiField("form_code")
		private String formCode;
		/**
		 * 创建时间
		 */
		@ApiField("gmt_create")
		private Date gmtCreate;
		/**
		 * 修改时间
		 */
		@ApiField("gmt_modified")
		private Date gmtModified;
		/**
		 * 创建时是否幂等的标志
		 */
		@ApiField("is_create_idempotent")
		private Boolean isCreateIdempotent;
		/**
		 * 商品id
		 */
		@ApiField("item_id")
		private Long itemId;
		/**
		 * 采买平台
		 */
		@ApiField("market")
		private String market;
		/**
		 * 权益模板名称
		 */
		@ApiField("name")
		private String name;
		/**
		 * 模板创建者ID所属的账号体系
		 */
		@ApiField("op_acct_sys")
		private String opAcctSys;
		/**
		 * 外部模板ID
		 */
		@ApiField("out_template_id")
		private String outTemplateId;
		/**
		 * 对应的pc权益类型
		 */
		@ApiField("pc_type")
		private Long pcType;
		/**
		 * 独占模板的计划ID
		 */
		@ApiField("plan_id")
		private Long planId;
		/**
		 * 模板对应奖品的数量
		 */
		@ApiField("prize_count")
		private Long prizeCount;
		/**
		 * 指定要创建的奖品features
		 */
		@ApiField("prize_features")
		private String prizeFeatures;
		/**
		 * 权益创建者ID
		 */
		@ApiField("product_code")
		private String productCode;
		/**
		 * 权益创建者ID
		 */
		@ApiField("provider_id")
		private Long providerId;
		/**
		 * 模板创建者花名或者淘宝账号名
		 */
		@ApiField("provider_no")
		private String providerNo;
		/**
		 * 模板描述
		 */
		@ApiField("remark")
		private String remark;
		/**
		 * 模板剩余金额
		 */
		@ApiField("rest_amount")
		private Long restAmount;
		/**
		 * 投放渠道
		 */
		@ApiField("sen_channel")
		private String senChannel;
		/**
		 * 模板面额已发放量
		 */
		@ApiField("sent_amount")
		private Long sentAmount;
		/**
		 * 模板个数已发放量
		 */
		@ApiField("sent_count")
		private Long sentCount;
		/**
		 * skuId
		 */
		@ApiField("sku_id")
		private Long skuId;
		/**
		 * 状态
		 */
		@ApiField("status")
		private Long status;
		/**
		 * 状态中文标签供小二端前端使用
		 */
		@ApiField("status_tag")
		private String statusTag;
		/**
		 * 权益模板ID
		 */
		@ApiField("template_id")
		private Long templateId;
		/**
		 * 模板面额总库存
		 */
		@ApiField("total_amount")
		private Long totalAmount;
		/**
		 * 模板个数总库存
		 */
		@ApiField("total_count")
		private Long totalCount;
	

	public String getCreateApprovalUrl() {
			return this.createApprovalUrl;
		}
		public void setCreateApprovalUrl(String createApprovalUrl) {
			this.createApprovalUrl = createApprovalUrl;
		}
		public Date getEffectTime() {
			return this.effectTime;
		}
		public void setEffectTime(Date effectTime) {
			this.effectTime = effectTime;
		}
		public Date getExpireTime() {
			return this.expireTime;
		}
		public void setExpireTime(Date expireTime) {
			this.expireTime = expireTime;
		}
		public String getFeatures() {
			return this.features;
		}
		public void setFeatures(String features) {
			this.features = features;
		}
		public void setFeaturesString(String features) {
			this.features = features;
		}
		
		public String getFormCode() {
			return this.formCode;
		}
		public void setFormCode(String formCode) {
			this.formCode = formCode;
		}
		public Date getGmtCreate() {
			return this.gmtCreate;
		}
		public void setGmtCreate(Date gmtCreate) {
			this.gmtCreate = gmtCreate;
		}
		public Date getGmtModified() {
			return this.gmtModified;
		}
		public void setGmtModified(Date gmtModified) {
			this.gmtModified = gmtModified;
		}
		public Boolean getIsCreateIdempotent() {
			return this.isCreateIdempotent;
		}
		public void setIsCreateIdempotent(Boolean isCreateIdempotent) {
			this.isCreateIdempotent = isCreateIdempotent;
		}
		public Long getItemId() {
			return this.itemId;
		}
		public void setItemId(Long itemId) {
			this.itemId = itemId;
		}
		public String getMarket() {
			return this.market;
		}
		public void setMarket(String market) {
			this.market = market;
		}
		public String getName() {
			return this.name;
		}
		public void setName(String name) {
			this.name = name;
		}
		public String getOpAcctSys() {
			return this.opAcctSys;
		}
		public void setOpAcctSys(String opAcctSys) {
			this.opAcctSys = opAcctSys;
		}
		public String getOutTemplateId() {
			return this.outTemplateId;
		}
		public void setOutTemplateId(String outTemplateId) {
			this.outTemplateId = outTemplateId;
		}
		public Long getPcType() {
			return this.pcType;
		}
		public void setPcType(Long pcType) {
			this.pcType = pcType;
		}
		public Long getPlanId() {
			return this.planId;
		}
		public void setPlanId(Long planId) {
			this.planId = planId;
		}
		public Long getPrizeCount() {
			return this.prizeCount;
		}
		public void setPrizeCount(Long prizeCount) {
			this.prizeCount = prizeCount;
		}
		public String getPrizeFeatures() {
			return this.prizeFeatures;
		}
		public void setPrizeFeatures(String prizeFeatures) {
			this.prizeFeatures = prizeFeatures;
		}
		public void setPrizeFeaturesString(String prizeFeatures) {
			this.prizeFeatures = prizeFeatures;
		}
		
		public String getProductCode() {
			return this.productCode;
		}
		public void setProductCode(String productCode) {
			this.productCode = productCode;
		}
		public Long getProviderId() {
			return this.providerId;
		}
		public void setProviderId(Long providerId) {
			this.providerId = providerId;
		}
		public String getProviderNo() {
			return this.providerNo;
		}
		public void setProviderNo(String providerNo) {
			this.providerNo = providerNo;
		}
		public String getRemark() {
			return this.remark;
		}
		public void setRemark(String remark) {
			this.remark = remark;
		}
		public Long getRestAmount() {
			return this.restAmount;
		}
		public void setRestAmount(Long restAmount) {
			this.restAmount = restAmount;
		}
		public String getSenChannel() {
			return this.senChannel;
		}
		public void setSenChannel(String senChannel) {
			this.senChannel = senChannel;
		}
		public Long getSentAmount() {
			return this.sentAmount;
		}
		public void setSentAmount(Long sentAmount) {
			this.sentAmount = sentAmount;
		}
		public Long getSentCount() {
			return this.sentCount;
		}
		public void setSentCount(Long sentCount) {
			this.sentCount = sentCount;
		}
		public Long getSkuId() {
			return this.skuId;
		}
		public void setSkuId(Long skuId) {
			this.skuId = skuId;
		}
		public Long getStatus() {
			return this.status;
		}
		public void setStatus(Long status) {
			this.status = status;
		}
		public String getStatusTag() {
			return this.statusTag;
		}
		public void setStatusTag(String statusTag) {
			this.statusTag = statusTag;
		}
		public Long getTemplateId() {
			return this.templateId;
		}
		public void setTemplateId(Long templateId) {
			this.templateId = templateId;
		}
		public Long getTotalAmount() {
			return this.totalAmount;
		}
		public void setTotalAmount(Long totalAmount) {
			this.totalAmount = totalAmount;
		}
		public Long getTotalCount() {
			return this.totalCount;
		}
		public void setTotalCount(Long totalCount) {
			this.totalCount = totalCount;
		}

}

	/**
 * 返回数据
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class QueryTemplateRespDTO extends TaobaoObject {

	private static final long serialVersionUID = 3613697425422819821L;

	/**
		 * 权益模板列表
		 */
		@ApiListField("templates")
		@ApiField("template_d_t_o")
		private List<TemplateDTO> templates;
	

	public List<TemplateDTO> getTemplates() {
			return this.templates;
		}
		public void setTemplates(List<TemplateDTO> templates) {
			this.templates = templates;
		}

}

	/**
 * 结果
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class ResultSupport extends TaobaoObject {

	private static final long serialVersionUID = 5649569962218473331L;

	/**
		 * 重试标志
		 */
		@ApiField("can_retry")
		private Boolean canRetry;
		/**
		 * 错误信息
		 */
		@ApiField("error_message")
		private String errorMessage;
		/**
		 * 错误码
		 */
		@ApiField("errorcode")
		private String errorcode;
		/**
		 * true
		 */
		@ApiField("issuccess")
		private Boolean issuccess;
		/**
		 * 返回数据
		 */
		@ApiField("model")
		private QueryTemplateRespDTO model;
		/**
		 * 中文错误信息
		 */
		@ApiField("show_error_message")
		private String showErrorMessage;
	

	public Boolean getCanRetry() {
			return this.canRetry;
		}
		public void setCanRetry(Boolean canRetry) {
			this.canRetry = canRetry;
		}
		public String getErrorMessage() {
			return this.errorMessage;
		}
		public void setErrorMessage(String errorMessage) {
			this.errorMessage = errorMessage;
		}
		public String getErrorcode() {
			return this.errorcode;
		}
		public void setErrorcode(String errorcode) {
			this.errorcode = errorcode;
		}
		public Boolean getIssuccess() {
			return this.issuccess;
		}
		public void setIssuccess(Boolean issuccess) {
			this.issuccess = issuccess;
		}
		public QueryTemplateRespDTO getModel() {
			return this.model;
		}
		public void setModel(QueryTemplateRespDTO model) {
			this.model = model;
		}
		public String getShowErrorMessage() {
			return this.showErrorMessage;
		}
		public void setShowErrorMessage(String showErrorMessage) {
			this.showErrorMessage = showErrorMessage;
		}

}



}
