package com.taobao.api.domain;

import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.mapping.ApiListField;
import com.taobao.api.TaobaoObject;
import java.util.Date;


/**
 * 券详情
 *
 * @author top auto create
 * @since 1.0, null
 */
public class AllsparkSellerCouponDetail extends TaobaoObject {

	private static final long serialVersionUID = 4763836624273439268L;

	/**
	 * 面额
	 */
	@ApiField("amount")
	private Long amount;

	/**
	 * 已领取数量
	 */
	@ApiField("apply_count")
	private Long applyCount;

	/**
	 * 券类型
	 */
	@ApiField("coupon_type")
	private Long couponType;

	/**
	 * 券类型
	 */
	@ApiField("coupon_type_name")
	private String couponTypeName;

	/**
	 * 券失效时间
	 */
	@ApiField("end_time")
	private Date endTime;

	/**
	 * 商品优惠券会有商品id集合
	 */
	@ApiListField("item_ids")
	@ApiField("number")
	private List<Long> itemIds;

	/**
	 * 模板限领数量
	 */
	@ApiField("person_limit_count")
	private Long personLimitCount;

	/**
	 * 保留数量
	 */
	@ApiField("reserve_count")
	private Long reserveCount;

	/**
	 * 卖家ID
	 */
	@ApiField("seller_id")
	private Long sellerId;

	/**
	 * 卖家昵称
	 */
	@ApiField("seller_nick")
	private String sellerNick;

	/**
	 * 店铺名称
	 */
	@ApiField("shop_name")
	private String shopName;

	/**
	 * 券对外ID
	 */
	@ApiField("spread_id")
	private String spreadId;

	/**
	 * 满足金额阀值  如订单满多少元才可用
	 */
	@ApiField("start_fee")
	private Long startFee;

	/**
	 * 券生效时间
	 */
	@ApiField("start_time")
	private Date startTime;

	/**
	 * 状态信息
	 */
	@ApiField("status")
	private Long status;

	/**
	 * 状态名称
	 */
	@ApiField("status_name")
	private String statusName;

	/**
	 * 券名称
	 */
	@ApiField("title")
	private String title;

	/**
	 * 设置发券数量总数
	 */
	@ApiField("total_count")
	private String totalCount;

	/**
	 * mtop 店铺链接
	 */
	@ApiField("url")
	private String url;


	public Long getAmount() {
		return this.amount;
	}
	public void setAmount(Long amount) {
		this.amount = amount;
	}

	public Long getApplyCount() {
		return this.applyCount;
	}
	public void setApplyCount(Long applyCount) {
		this.applyCount = applyCount;
	}

	public Long getCouponType() {
		return this.couponType;
	}
	public void setCouponType(Long couponType) {
		this.couponType = couponType;
	}

	public String getCouponTypeName() {
		return this.couponTypeName;
	}
	public void setCouponTypeName(String couponTypeName) {
		this.couponTypeName = couponTypeName;
	}

	public Date getEndTime() {
		return this.endTime;
	}
	public void setEndTime(Date endTime) {
		this.endTime = endTime;
	}

	public List<Long> getItemIds() {
		return this.itemIds;
	}
	public void setItemIds(List<Long> itemIds) {
		this.itemIds = itemIds;
	}

	public Long getPersonLimitCount() {
		return this.personLimitCount;
	}
	public void setPersonLimitCount(Long personLimitCount) {
		this.personLimitCount = personLimitCount;
	}

	public Long getReserveCount() {
		return this.reserveCount;
	}
	public void setReserveCount(Long reserveCount) {
		this.reserveCount = reserveCount;
	}

	public Long getSellerId() {
		return this.sellerId;
	}
	public void setSellerId(Long sellerId) {
		this.sellerId = sellerId;
	}

	public String getSellerNick() {
		return this.sellerNick;
	}
	public void setSellerNick(String sellerNick) {
		this.sellerNick = sellerNick;
	}

	public String getShopName() {
		return this.shopName;
	}
	public void setShopName(String shopName) {
		this.shopName = shopName;
	}

	public String getSpreadId() {
		return this.spreadId;
	}
	public void setSpreadId(String spreadId) {
		this.spreadId = spreadId;
	}

	public Long getStartFee() {
		return this.startFee;
	}
	public void setStartFee(Long startFee) {
		this.startFee = startFee;
	}

	public Date getStartTime() {
		return this.startTime;
	}
	public void setStartTime(Date startTime) {
		this.startTime = startTime;
	}

	public Long getStatus() {
		return this.status;
	}
	public void setStatus(Long status) {
		this.status = status;
	}

	public String getStatusName() {
		return this.statusName;
	}
	public void setStatusName(String statusName) {
		this.statusName = statusName;
	}

	public String getTitle() {
		return this.title;
	}
	public void setTitle(String title) {
		this.title = title;
	}

	public String getTotalCount() {
		return this.totalCount;
	}
	public void setTotalCount(String totalCount) {
		this.totalCount = totalCount;
	}

	public String getUrl() {
		return this.url;
	}
	public void setUrl(String url) {
		this.url = url;
	}

}
