package com.taobao.api.domain;

import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.TaobaoObject;


/**
 * 单用户权益发放请求
 *
 * @author top auto create
 * @since 1.0, null
 */
public class SingleBenefitRequest extends TaobaoObject {

	private static final long serialVersionUID = 4697159648129732276L;

	/**
	 * 权益类型    其中ALIPAY_COUPON 对应的type值是1
	 */
	@ApiField("benefit_type")
	private Long benefitType;

	/**
	 * 权益关联的活动ID
	 */
	@ApiField("biz_id")
	private String bizId;

	/**
	 * 支持每日赢宝箱多个卡片类型，默认“游戏惊喜”卡片，可选“美妆”卡片beauty
	 */
	@ApiField("card_type")
	private String cardType;

	/**
	 * 活动详情id
	 */
	@ApiField("detail_id")
	private Long detailId;

	/**
	 * 调用信息
	 */
	@ApiField("provider_key")
	private String providerKey;

	/**
	 * 卖家用户id,　可通过接口taobao.user.seller.get获取
	 */
	@ApiField("purchaser_id")
	private Long purchaserId;

	/**
	 * 权益接收者id
	 */
	@ApiField("receiver_id")
	private Long receiverId;

	/**
	 * 关联活动id
	 */
	@ApiField("relation_id")
	private Long relationId;

	/**
	 * 权益发放数量
	 */
	@ApiField("send_count")
	private Long sendCount;

	/**
	 * 调试线索
	 */
	@ApiField("trace_id")
	private String traceId;

	/**
	 * 事务id
	 */
	@ApiField("unique_id")
	private String uniqueId;


	public Long getBenefitType() {
		return this.benefitType;
	}
	public void setBenefitType(Long benefitType) {
		this.benefitType = benefitType;
	}

	public String getBizId() {
		return this.bizId;
	}
	public void setBizId(String bizId) {
		this.bizId = bizId;
	}

	public String getCardType() {
		return this.cardType;
	}
	public void setCardType(String cardType) {
		this.cardType = cardType;
	}

	public Long getDetailId() {
		return this.detailId;
	}
	public void setDetailId(Long detailId) {
		this.detailId = detailId;
	}

	public String getProviderKey() {
		return this.providerKey;
	}
	public void setProviderKey(String providerKey) {
		this.providerKey = providerKey;
	}

	public Long getPurchaserId() {
		return this.purchaserId;
	}
	public void setPurchaserId(Long purchaserId) {
		this.purchaserId = purchaserId;
	}

	public Long getReceiverId() {
		return this.receiverId;
	}
	public void setReceiverId(Long receiverId) {
		this.receiverId = receiverId;
	}

	public Long getRelationId() {
		return this.relationId;
	}
	public void setRelationId(Long relationId) {
		this.relationId = relationId;
	}

	public Long getSendCount() {
		return this.sendCount;
	}
	public void setSendCount(Long sendCount) {
		this.sendCount = sendCount;
	}

	public String getTraceId() {
		return this.traceId;
	}
	public void setTraceId(String traceId) {
		this.traceId = traceId;
	}

	public String getUniqueId() {
		return this.uniqueId;
	}
	public void setUniqueId(String uniqueId) {
		this.uniqueId = uniqueId;
	}

}
