package com.taobao.api.internal.tmc;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.util.concurrent.atomic.AtomicBoolean;

/**
 * TMC工作线程性能监视器
 * 性能测试时用，一般不开
 */
public class WorkerThreadPerfMon {
    private static final Log LOG = LogFactory.getLog(WorkerThreadPerfMon.class);

    /**
     * 上次消息处理完成的时间
     */
    private final ThreadLocal<Long> lastFinishHandleMsgTime = new ThreadLocal<Long>();

    /**
     * 线程空闲总时长
     */
    private final ThreadLocal<Long> idleTime = new ThreadLocal<Long>();

    /**
     * 线程开始工作的时间
     */
    private final ThreadLocal<Long> startTime = new ThreadLocal<Long>();

    /**
     * 上次输出日志的时间
     */
    private final ThreadLocal<Long> lastLogTime = new ThreadLocal<Long>();

    /**
     * 是否启用
     */
    private final AtomicBoolean enabled = new AtomicBoolean(false);

    public void enable() {
        enabled.set(true);
    }

    public void disable() {
        enabled.set(false);
    }

    public void beforeFinishHandleMsg() {
        if(!enabled.get()) {
            return;
        }
        lastFinishHandleMsgTime.set(System.currentTimeMillis());
    }

    public void afterRetrieveMsgFromQueue() {
        try {
            if(!enabled.get()) {
                return;
            }

            Long startTimeVal = startTime.get();
            if(startTimeVal == null) {
                startTimeVal = System.currentTimeMillis();
                startTime.set(startTimeVal);
            }

            Long lastFinishHandleMsgTimeVal = lastFinishHandleMsgTime.get();
            if(lastFinishHandleMsgTimeVal == null) {
                return;
            }

            long curTime = System.currentTimeMillis();
            long lastIdleTime = curTime - lastFinishHandleMsgTimeVal;
            Long idleTimeVal = idleTime.get();
            if(idleTimeVal == null) {
                idleTimeVal = 0L;
            }
            // 累加线程空闲时间
            idleTimeVal += lastIdleTime;
            idleTime.set(idleTimeVal);

            Long lastLogTimeVal = lastLogTime.get();
            if(lastLogTimeVal == null || curTime - lastLogTimeVal > 1000) {
                // 输出线程工作时间占比，每秒最多输出一次
                long totalTime = curTime - startTimeVal;
                double idlePercent = 1.0 - (((double)idleTimeVal) / ((double)totalTime));
                LOG.info(String.format("%d,%.20f", curTime, idlePercent));
                lastLogTime.set(curTime);
            }
        } catch (Throwable e) {
            LOG.error("afterRetrieveMsgFromQueue err", e);
        }
    }
}
