package com.taobao.api.request;

import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.mapping.ApiListField;
import com.taobao.api.TaobaoObject;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.json.JSONWriter;
import com.taobao.api.response.AlibabaArgusUpdateredriskResponse;

/**
 * TOP API: alibaba.argus.updateredrisk request
 * 
 * @author top auto create
 * @since 1.0, 2022.04.28
 */
public class AlibabaArgusUpdateredriskRequest extends BaseTaobaoRequest<AlibabaArgusUpdateredriskResponse> {
	
	

	/** 
	* 红线价格参数
	 */
	private String redRiskUpdateFactor;

	public void setRedRiskUpdateFactor(String redRiskUpdateFactor) {
		this.redRiskUpdateFactor = redRiskUpdateFactor;
	}

	public void setRedRiskUpdateFactor(RedRiskUpdateFactor redRiskUpdateFactor) {
		this.redRiskUpdateFactor = new JSONWriter(false,true).write(redRiskUpdateFactor);
	}

	public String getRedRiskUpdateFactor() {
		return this.redRiskUpdateFactor;
	}

	public String getApiMethodName() {
		return "alibaba.argus.updateredrisk";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("red_risk_update_factor", this.redRiskUpdateFactor);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<AlibabaArgusUpdateredriskResponse> getResponseClass() {
		return AlibabaArgusUpdateredriskResponse.class;
	}

	public void check() throws ApiRuleException {
	}
	
	/**
 * 新增sku级别红线价格
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class SkuRedRiskFactor extends TaobaoObject {

	private static final long serialVersionUID = 5839439752729918582L;

	/**
		 * sku红线价格
		 */
		@ApiField("amount_at")
		private Long amountAt;
		/**
		 * skuId
		 */
		@ApiField("sku_id")
		private String skuId;
	

	public Long getAmountAt() {
			return this.amountAt;
		}
		public void setAmountAt(Long amountAt) {
			this.amountAt = amountAt;
		}
		public String getSkuId() {
			return this.skuId;
		}
		public void setSkuId(String skuId) {
			this.skuId = skuId;
		}

}

	/**
 * 风险等级设置
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class RiskLevelParam extends TaobaoObject {

	private static final long serialVersionUID = 3825328776473952351L;

	/**
		 * 风险等级(可选值:higher-risk,middle-risk,low-risk)
		 */
		@ApiField("key")
		private String key;
		/**
		 * 风险等级比例左边值
		 */
		@ApiField("left_range")
		private Long leftRange;
		/**
		 * 风险等级比例右边值
		 */
		@ApiField("right_range")
		private Long rightRange;
	

	public String getKey() {
			return this.key;
		}
		public void setKey(String key) {
			this.key = key;
		}
		public Long getLeftRange() {
			return this.leftRange;
		}
		public void setLeftRange(Long leftRange) {
			this.leftRange = leftRange;
		}
		public Long getRightRange() {
			return this.rightRange;
		}
		public void setRightRange(Long rightRange) {
			this.rightRange = rightRange;
		}

}

	/**
 * 红线价格参数
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class RedRiskUpdateFactor extends TaobaoObject {

	private static final long serialVersionUID = 8845556394669811654L;

	/**
		 * 商品红线价格
		 */
		@ApiField("amount_at")
		private Long amountAt;
		/**
		 * 商品id
		 */
		@ApiField("item_id")
		private Long itemId;
		/**
		 * 需要删除的sku红线价格
		 */
		@ApiListField("remove_sku_ids")
		@ApiField("number")
		private List<Long> removeSkuIds;
		/**
		 * 风险等级设置
		 */
		@ApiListField("risk_levels")
		@ApiField("risk_level_param")
		private List<RiskLevelParam> riskLevels;
		/**
		 * 新增sku级别红线价格
		 */
		@ApiListField("sku_risk_factors")
		@ApiField("sku_red_risk_factor")
		private List<SkuRedRiskFactor> skuRiskFactors;
	

	public Long getAmountAt() {
			return this.amountAt;
		}
		public void setAmountAt(Long amountAt) {
			this.amountAt = amountAt;
		}
		public Long getItemId() {
			return this.itemId;
		}
		public void setItemId(Long itemId) {
			this.itemId = itemId;
		}
		public List<Long> getRemoveSkuIds() {
			return this.removeSkuIds;
		}
		public void setRemoveSkuIds(List<Long> removeSkuIds) {
			this.removeSkuIds = removeSkuIds;
		}
		public List<RiskLevelParam> getRiskLevels() {
			return this.riskLevels;
		}
		public void setRiskLevels(List<RiskLevelParam> riskLevels) {
			this.riskLevels = riskLevels;
		}
		public List<SkuRedRiskFactor> getSkuRiskFactors() {
			return this.skuRiskFactors;
		}
		public void setSkuRiskFactors(List<SkuRedRiskFactor> skuRiskFactors) {
			this.skuRiskFactors = skuRiskFactors;
		}

}


}