package com.taobao.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.AlibabaBenefitQueryResponse;

/**
 * TOP API: alibaba.benefit.query request
 * 
 * @author top auto create
 * @since 1.0, 2022.04.28
 */
public class AlibabaBenefitQueryRequest extends BaseTaobaoRequest<AlibabaBenefitQueryResponse> {
	
	

	/** 
	* 商家来源身份标识（"promotion-"+appId）
	 */
	private String appName;

	/** 
	* 表示奖池类型（发奖奖池传1，抽奖传0）
	 */
	private String awardType;

	/** 
	* 奖池编号
	 */
	private String ename;

	public void setAppName(String appName) {
		this.appName = appName;
	}

	public String getAppName() {
		return this.appName;
	}

	public void setAwardType(String awardType) {
		this.awardType = awardType;
	}

	public String getAwardType() {
		return this.awardType;
	}

	public void setEname(String ename) {
		this.ename = ename;
	}

	public String getEname() {
		return this.ename;
	}

	public String getApiMethodName() {
		return "alibaba.benefit.query";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("app_name", this.appName);
		txtParams.put("award_type", this.awardType);
		txtParams.put("ename", this.ename);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<AlibabaBenefitQueryResponse> getResponseClass() {
		return AlibabaBenefitQueryResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(appName, "appName");
		RequestCheckUtils.checkNotEmpty(ename, "ename");
	}
	

}