package com.taobao.api.request;

import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.AlibabaBenefitTypeCreateResponse;

/**
 * TOP API: alibaba.benefit.type.create request
 * 
 * @author top auto create
 * @since 1.0, 2019.12.21
 */
public class AlibabaBenefitTypeCreateRequest extends BaseTaobaoRequest<AlibabaBenefitTypeCreateResponse> {
	
	

	/** 
	* 1
	 */
	private String benefitName;

	/** 
	* 1
	 */
	private byte featureMap;

	/** 
	* 1
	 */
	private String productCode;

	public void setBenefitName(String benefitName) {
		this.benefitName = benefitName;
	}

	public String getBenefitName() {
		return this.benefitName;
	}

	public void setFeatureMap(byte featureMap) {
		this.featureMap = featureMap;
	}

	public byte getFeatureMap() {
		return this.featureMap;
	}

	public void setProductCode(String productCode) {
		this.productCode = productCode;
	}

	public String getProductCode() {
		return this.productCode;
	}

	public String getApiMethodName() {
		return "alibaba.benefit.type.create";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("benefit_name", this.benefitName);
		txtParams.put("feature_map", this.featureMap);
		txtParams.put("product_code", this.productCode);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<AlibabaBenefitTypeCreateResponse> getResponseClass() {
		return AlibabaBenefitTypeCreateResponse.class;
	}

	public void check() throws ApiRuleException {
	}
	

}