package com.taobao.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import com.taobao.api.internal.util.json.JSONValidatingReader;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.AlibabaLatourStrategyIssueResponse;

/**
 * TOP API: alibaba.latour.strategy.issue request
 * 
 * @author top auto create
 * @since 1.0, 2022.07.12
 */
public class AlibabaLatourStrategyIssueRequest extends BaseTaobaoRequest<AlibabaLatourStrategyIssueResponse> {
	
	

	/** 
	* 发放渠道
	 */
	private String channel;

	/** 
	* 扩展参数
	 */
	private String extraData;

	/** 
	* 算法容灾
	 */
	private Boolean failoverAlgorithmResult;

	/** 
	* 幂等id
	 */
	private String idempotentId;

	/** 
	* 是否需要过安全
	 */
	private Boolean needIdentifyRisk;

	/** 
	* openid
	 */
	private String openid;

	/** 
	* 指定发放权益code
	 */
	private String selectedBenefitCode;

	/** 
	* 投放计划code
	 */
	private String strategyCode;

	/** 
	* 转换用户类型
	 */
	private String transformedUserType;

	/** 
	* 除非有特殊申请，默认不允许使用该参数，请通过用户授权token传递用户信息
	 */
	private String userId;

	/** 
	* 除非有特殊申请，默认不允许使用该参数，请通过用户授权token传递用户信息
	 */
	private String userNick;

	/** 
	* 用户类型
	 */
	private String userType;

	public void setChannel(String channel) {
		this.channel = channel;
	}

	public String getChannel() {
		return this.channel;
	}

	public void setExtraData(String extraData) {
		this.extraData = extraData;
	}
	public void setExtraDataString(String extraData) {
		this.extraData = extraData;
	}

	public String getExtraData() {
		return this.extraData;
	}

	public void setFailoverAlgorithmResult(Boolean failoverAlgorithmResult) {
		this.failoverAlgorithmResult = failoverAlgorithmResult;
	}

	public Boolean getFailoverAlgorithmResult() {
		return this.failoverAlgorithmResult;
	}

	public void setIdempotentId(String idempotentId) {
		this.idempotentId = idempotentId;
	}

	public String getIdempotentId() {
		return this.idempotentId;
	}

	public void setNeedIdentifyRisk(Boolean needIdentifyRisk) {
		this.needIdentifyRisk = needIdentifyRisk;
	}

	public Boolean getNeedIdentifyRisk() {
		return this.needIdentifyRisk;
	}

	public void setOpenid(String openid) {
		this.openid = openid;
	}

	public String getOpenid() {
		return this.openid;
	}

	public void setSelectedBenefitCode(String selectedBenefitCode) {
		this.selectedBenefitCode = selectedBenefitCode;
	}

	public String getSelectedBenefitCode() {
		return this.selectedBenefitCode;
	}

	public void setStrategyCode(String strategyCode) {
		this.strategyCode = strategyCode;
	}

	public String getStrategyCode() {
		return this.strategyCode;
	}

	public void setTransformedUserType(String transformedUserType) {
		this.transformedUserType = transformedUserType;
	}

	public String getTransformedUserType() {
		return this.transformedUserType;
	}

	public void setUserId(String userId) {
		this.userId = userId;
	}

	public String getUserId() {
		return this.userId;
	}

	public void setUserNick(String userNick) {
		this.userNick = userNick;
	}

	public String getUserNick() {
		return this.userNick;
	}

	public void setUserType(String userType) {
		this.userType = userType;
	}

	public String getUserType() {
		return this.userType;
	}

	public String getApiMethodName() {
		return "alibaba.latour.strategy.issue";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("channel", this.channel);
		txtParams.put("extra_data", this.extraData);
		txtParams.put("failover_algorithm_result", this.failoverAlgorithmResult);
		txtParams.put("idempotent_id", this.idempotentId);
		txtParams.put("need_identify_risk", this.needIdentifyRisk);
		txtParams.put("openid", this.openid);
		txtParams.put("selected_benefit_code", this.selectedBenefitCode);
		txtParams.put("strategy_code", this.strategyCode);
		txtParams.put("transformed_user_type", this.transformedUserType);
		txtParams.put("user_id", this.userId);
		txtParams.put("user_nick", this.userNick);
		txtParams.put("user_type", this.userType);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<AlibabaLatourStrategyIssueResponse> getResponseClass() {
		return AlibabaLatourStrategyIssueResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(channel, "channel");
		RequestCheckUtils.checkNotEmpty(strategyCode, "strategyCode");
	}
	

}