package com.taobao.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.AlibabaLatourStrategyShowResponse;

/**
 * TOP API: alibaba.latour.strategy.show request
 * 
 * @author top auto create
 * @since 1.0, 2022.07.28
 */
public class AlibabaLatourStrategyShowRequest extends BaseTaobaoRequest<AlibabaLatourStrategyShowResponse> {
	
	

	/** 
	* 渠道
	 */
	private String channel;

	/** 
	* 当面分页
	 */
	private Long currentPage;

	/** 
	* 过滤人群
	 */
	private Boolean filterCrowd;

	/** 
	* 过滤无库存权益
	 */
	private Boolean filterEmptyInventory;

	/** 
	* 是否需要调用安全校验服务
	 */
	private Boolean needIdentifyRisk;

	/** 
	* openid
	 */
	private String openid;

	/** 
	* 每页权益数
	 */
	private Long pageSize;

	/** 
	* 不带出hadWin状态
	 */
	private Boolean skipWithHadWin;

	/** 
	* 投放计划code
	 */
	private String strategyCode;

	/** 
	* 要转换的账户类型
	 */
	private String transformedUserType;

	/** 
	* 用户id，除非有特殊申请，默认不允许使用该参数，请通过用户授权token传递用户信息
	 */
	private String userId;

	/** 
	* 用户昵称，除非有特殊申请，默认不允许使用该参数，请通过用户授权token传递用户信息
	 */
	private String userNick;

	/** 
	* 当面账户类型
	 */
	private String userType;

	/** 
	* 是否需要权益维度的权益核销实例
	 */
	private Boolean withBenefitInstance;

	/** 
	* 是否需要投放计划维度的权益核销实例
	 */
	private Boolean withStrategyInstance;

	/** 
	* 带出测试权益
	 */
	private Boolean withTestBenefit;

	public void setChannel(String channel) {
		this.channel = channel;
	}

	public String getChannel() {
		return this.channel;
	}

	public void setCurrentPage(Long currentPage) {
		this.currentPage = currentPage;
	}

	public Long getCurrentPage() {
		return this.currentPage;
	}

	public void setFilterCrowd(Boolean filterCrowd) {
		this.filterCrowd = filterCrowd;
	}

	public Boolean getFilterCrowd() {
		return this.filterCrowd;
	}

	public void setFilterEmptyInventory(Boolean filterEmptyInventory) {
		this.filterEmptyInventory = filterEmptyInventory;
	}

	public Boolean getFilterEmptyInventory() {
		return this.filterEmptyInventory;
	}

	public void setNeedIdentifyRisk(Boolean needIdentifyRisk) {
		this.needIdentifyRisk = needIdentifyRisk;
	}

	public Boolean getNeedIdentifyRisk() {
		return this.needIdentifyRisk;
	}

	public void setOpenid(String openid) {
		this.openid = openid;
	}

	public String getOpenid() {
		return this.openid;
	}

	public void setPageSize(Long pageSize) {
		this.pageSize = pageSize;
	}

	public Long getPageSize() {
		return this.pageSize;
	}

	public void setSkipWithHadWin(Boolean skipWithHadWin) {
		this.skipWithHadWin = skipWithHadWin;
	}

	public Boolean getSkipWithHadWin() {
		return this.skipWithHadWin;
	}

	public void setStrategyCode(String strategyCode) {
		this.strategyCode = strategyCode;
	}

	public String getStrategyCode() {
		return this.strategyCode;
	}

	public void setTransformedUserType(String transformedUserType) {
		this.transformedUserType = transformedUserType;
	}

	public String getTransformedUserType() {
		return this.transformedUserType;
	}

	public void setUserId(String userId) {
		this.userId = userId;
	}

	public String getUserId() {
		return this.userId;
	}

	public void setUserNick(String userNick) {
		this.userNick = userNick;
	}

	public String getUserNick() {
		return this.userNick;
	}

	public void setUserType(String userType) {
		this.userType = userType;
	}

	public String getUserType() {
		return this.userType;
	}

	public void setWithBenefitInstance(Boolean withBenefitInstance) {
		this.withBenefitInstance = withBenefitInstance;
	}

	public Boolean getWithBenefitInstance() {
		return this.withBenefitInstance;
	}

	public void setWithStrategyInstance(Boolean withStrategyInstance) {
		this.withStrategyInstance = withStrategyInstance;
	}

	public Boolean getWithStrategyInstance() {
		return this.withStrategyInstance;
	}

	public void setWithTestBenefit(Boolean withTestBenefit) {
		this.withTestBenefit = withTestBenefit;
	}

	public Boolean getWithTestBenefit() {
		return this.withTestBenefit;
	}

	public String getApiMethodName() {
		return "alibaba.latour.strategy.show";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("channel", this.channel);
		txtParams.put("current_page", this.currentPage);
		txtParams.put("filter_crowd", this.filterCrowd);
		txtParams.put("filter_empty_inventory", this.filterEmptyInventory);
		txtParams.put("need_identify_risk", this.needIdentifyRisk);
		txtParams.put("openid", this.openid);
		txtParams.put("page_size", this.pageSize);
		txtParams.put("skip_with_had_win", this.skipWithHadWin);
		txtParams.put("strategy_code", this.strategyCode);
		txtParams.put("transformed_user_type", this.transformedUserType);
		txtParams.put("user_id", this.userId);
		txtParams.put("user_nick", this.userNick);
		txtParams.put("user_type", this.userType);
		txtParams.put("with_benefit_instance", this.withBenefitInstance);
		txtParams.put("with_strategy_instance", this.withStrategyInstance);
		txtParams.put("with_test_benefit", this.withTestBenefit);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<AlibabaLatourStrategyShowResponse> getResponseClass() {
		return AlibabaLatourStrategyShowResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(channel, "channel");
		RequestCheckUtils.checkNotEmpty(strategyCode, "strategyCode");
	}
	

}