package com.taobao.api.request;

import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.TaobaoObject;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.json.JSONWriter;
import com.taobao.api.response.AlibabaMktCellInterplayExecuteReadResponse;

/**
 * TOP API: alibaba.mkt.cell.interplay.execute.read request
 * 
 * @author top auto create
 * @since 1.0, 2022.08.22
 */
public class AlibabaMktCellInterplayExecuteReadRequest extends BaseTaobaoRequest<AlibabaMktCellInterplayExecuteReadResponse> {
	
	

	/** 
	* 请求参数
	 */
	private String interPlayExecuteReadTopRequest;

	public void setInterPlayExecuteReadTopRequest(String interPlayExecuteReadTopRequest) {
		this.interPlayExecuteReadTopRequest = interPlayExecuteReadTopRequest;
	}

	public void setInterPlayExecuteReadTopRequest(InterPlayExecuteReadTopRequest interPlayExecuteReadTopRequest) {
		this.interPlayExecuteReadTopRequest = new JSONWriter(false,true).write(interPlayExecuteReadTopRequest);
	}

	public String getInterPlayExecuteReadTopRequest() {
		return this.interPlayExecuteReadTopRequest;
	}

	public String getApiMethodName() {
		return "alibaba.mkt.cell.interplay.execute.read";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("inter_play_execute_read_top_request", this.interPlayExecuteReadTopRequest);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<AlibabaMktCellInterplayExecuteReadResponse> getResponseClass() {
		return AlibabaMktCellInterplayExecuteReadResponse.class;
	}

	public void check() throws ApiRuleException {
	}
	
	/**
 * 请求参数
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class InterPlayExecuteReadTopRequest extends TaobaoObject {

	private static final long serialVersionUID = 5711412862943265456L;

	/**
		 * openId
		 */
		@ApiField("open_id")
		private String openId;
		/**
		 * 业务请求参数
		 */
		@ApiField("top_module_param")
		private String topModuleParam;
	

	public String getOpenId() {
			return this.openId;
		}
		public void setOpenId(String openId) {
			this.openId = openId;
		}
		public String getTopModuleParam() {
			return this.topModuleParam;
		}
		public void setTopModuleParam(String topModuleParam) {
			this.topModuleParam = topModuleParam;
		}

}


}