package com.taobao.api.request;

import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.TaobaoObject;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.json.JSONWriter;
import com.taobao.api.response.AlibabaMktCellInterplayExecuteWriteResponse;

/**
 * TOP API: alibaba.mkt.cell.interplay.execute.write request
 * 
 * @author top auto create
 * @since 1.0, 2022.08.29
 */
public class AlibabaMktCellInterplayExecuteWriteRequest extends BaseTaobaoRequest<AlibabaMktCellInterplayExecuteWriteResponse> {
	
	

	/** 
	* 请求参数
	 */
	private String interPlayExecuteWriteTopRequest;

	public void setInterPlayExecuteWriteTopRequest(String interPlayExecuteWriteTopRequest) {
		this.interPlayExecuteWriteTopRequest = interPlayExecuteWriteTopRequest;
	}

	public void setInterPlayExecuteWriteTopRequest(InterPlayExecuteWriteTopRequest interPlayExecuteWriteTopRequest) {
		this.interPlayExecuteWriteTopRequest = new JSONWriter(false,true).write(interPlayExecuteWriteTopRequest);
	}

	public String getInterPlayExecuteWriteTopRequest() {
		return this.interPlayExecuteWriteTopRequest;
	}

	public String getApiMethodName() {
		return "alibaba.mkt.cell.interplay.execute.write";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("inter_play_execute_write_top_request", this.interPlayExecuteWriteTopRequest);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<AlibabaMktCellInterplayExecuteWriteResponse> getResponseClass() {
		return AlibabaMktCellInterplayExecuteWriteResponse.class;
	}

	public void check() throws ApiRuleException {
	}
	
	/**
 * 请求参数
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class InterPlayExecuteWriteTopRequest extends TaobaoObject {

	private static final long serialVersionUID = 3846477413121143129L;

	/**
		 * openId
		 */
		@ApiField("open_id")
		private String openId;
		/**
		 * 业务请求参数
		 */
		@ApiField("top_module_param")
		private String topModuleParam;
	

	public String getOpenId() {
			return this.openId;
		}
		public void setOpenId(String openId) {
			this.openId = openId;
		}
		public String getTopModuleParam() {
			return this.topModuleParam;
		}
		public void setTopModuleParam(String topModuleParam) {
			this.topModuleParam = topModuleParam;
		}

}


}