package com.taobao.api.request;

import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.TaobaoObject;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.json.JSONWriter;
import com.taobao.api.response.AlibabaOrightBenefitTemplateSendResponse;

/**
 * TOP API: alibaba.oright.benefit.template.send request
 * 
 * @author top auto create
 * @since 1.0, 2023.09.15
 */
public class AlibabaOrightBenefitTemplateSendRequest extends BaseTaobaoRequest<AlibabaOrightBenefitTemplateSendResponse> {
	
	

	/** 
	* 发放参数
	 */
	private String templateSendReq;

	public void setTemplateSendReq(String templateSendReq) {
		this.templateSendReq = templateSendReq;
	}

	public void setTemplateSendReq(TemplateSendBenefitTopReqDTO templateSendReq) {
		this.templateSendReq = new JSONWriter(false,true).write(templateSendReq);
	}

	public String getTemplateSendReq() {
		return this.templateSendReq;
	}

	public String getApiMethodName() {
		return "alibaba.oright.benefit.template.send";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("template_send_req", this.templateSendReq);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<AlibabaOrightBenefitTemplateSendResponse> getResponseClass() {
		return AlibabaOrightBenefitTemplateSendResponse.class;
	}

	public void check() throws ApiRuleException {
	}
	
	/**
 * 发放参数
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class TemplateSendBenefitTopReqDTO extends TaobaoObject {

	private static final long serialVersionUID = 1312159616418416125L;

	/**
		 * 幂等id
		 */
		@ApiField("out_transaction_id")
		private String outTransactionId;
		/**
		 * 权益模板创建者账号体系。如阿里小二创建的，就是BUC；如是商家创建的，就是商家TAO
		 */
		@ApiField("provider_acct_sys")
		private String providerAcctSys;
		/**
		 * 权益模板创建者ID。如阿里小二创建的，就是小二工号；如是商家创建的，就是商家ID
		 */
		@ApiField("provider_id")
		private Long providerId;
		/**
		 * 权益接收者账号体系
		 */
		@ApiField("receive_user_acct_sys")
		private String receiveUserAcctSys;
		/**
		 * 权益模板ID
		 */
		@ApiField("template_id")
		private Long templateId;
	

	public String getOutTransactionId() {
			return this.outTransactionId;
		}
		public void setOutTransactionId(String outTransactionId) {
			this.outTransactionId = outTransactionId;
		}
		public String getProviderAcctSys() {
			return this.providerAcctSys;
		}
		public void setProviderAcctSys(String providerAcctSys) {
			this.providerAcctSys = providerAcctSys;
		}
		public Long getProviderId() {
			return this.providerId;
		}
		public void setProviderId(Long providerId) {
			this.providerId = providerId;
		}
		public String getReceiveUserAcctSys() {
			return this.receiveUserAcctSys;
		}
		public void setReceiveUserAcctSys(String receiveUserAcctSys) {
			this.receiveUserAcctSys = receiveUserAcctSys;
		}
		public Long getTemplateId() {
			return this.templateId;
		}
		public void setTemplateId(Long templateId) {
			this.templateId = templateId;
		}

}


}